/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.ImmutableCollectors;
import java.util.Map;
import java.util.Objects;

public abstract class ApplyNodeRewriter
extends SimplePlanRewriter<Void> {
    protected SymbolReference reference;

    public ApplyNodeRewriter(SymbolReference reference) {
        this.reference = Objects.requireNonNull(reference, "reference is null");
    }

    @Override
    public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
        Expression expression = ExpressionNodeInliner.replaceExpression((Expression)this.reference, ApplyNodeRewriter.mapAssignmentSymbolsToExpression(node.getAssignments()));
        if (expression instanceof SymbolReference) {
            this.reference = (SymbolReference)expression;
            return context.defaultRewrite(node, context.get());
        }
        return node;
    }

    @Override
    public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
        if (node.getSubquery().getOutputSymbols().contains(Symbol.from((Expression)this.reference))) {
            return this.rewriteApply(node);
        }
        return context.defaultRewrite(node, context.get());
    }

    protected abstract PlanNode rewriteApply(ApplyNode var1);

    protected static Map<Expression, Expression> mapAssignmentSymbolsToExpression(Map<Symbol, Expression> assignments) {
        return (Map)assignments.entrySet().stream().collect(ImmutableCollectors.toImmutableMap(e -> ((Symbol)e.getKey()).toSymbolReference(), Map.Entry::getValue));
    }
}

