/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Approximate;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, metadata, session, analysis.getParameters());
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            Type[] types = (Type[])scope.getRelationType().getAllFields().stream().map(Field::getType).toArray(Type[]::new);
            RelationPlan withCoercions = this.addCoercions(subPlan, types);
            return new RelationPlan(withCoercions.getRoot(), scope, withCoercions.getOutputSymbols(), withCoercions.getSampleWeight());
        }
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : scope.getRelationType().getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList planOutputSymbols = outputSymbolsBuilder.build();
        Optional<ColumnHandle> sampleWeightColumn = this.metadata.getSampleWeightColumnHandle(this.session, handle);
        Symbol sampleWeightSymbol = null;
        if (sampleWeightColumn.isPresent()) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
            outputSymbolsBuilder.add((Object)sampleWeightSymbol);
            columns.put((Object)sampleWeightSymbol, (Object)sampleWeightColumn.get());
        }
        ImmutableList nodeOutputSymbols = outputSymbolsBuilder.build();
        TableScanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)nodeOutputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), null);
        return new RelationPlan(root, scope, (List<Symbol>)planOutputSymbols, Optional.ofNullable(sampleWeightSymbol));
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        return new RelationPlan(subPlan.getRoot(), this.analysis.getScope((Node)node), subPlan.getOutputSymbols(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        if (node.getColumnsToStratifyOn().isPresent()) {
            throw new UnsupportedOperationException("STRATIFY ON is not yet implemented");
        }
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        Symbol sampleWeightSymbol = null;
        if (node.getType() == SampledRelation.Type.POISSONIZED) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        }
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()), node.isRescaled(), Optional.ofNullable(sampleWeightSymbol));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getOutputSymbols(), Optional.ofNullable(sampleWeightSymbol));
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        if (node.getRight() instanceof Unnest || node.getRight() instanceof AliasedRelation && ((AliasedRelation)node.getRight()).getRelation() instanceof Unnest) {
            Unnest unnest = node.getRight() instanceof AliasedRelation ? (Unnest)((AliasedRelation)node.getRight()).getRelation() : (Unnest)node.getRight();
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                SemanticExceptions.throwNotSupportedException((Node)unnest, "UNNEST on other than the right side of CROSS JOIN");
            }
            return this.planCrossJoinUnnest(leftPlan, node, unnest);
        }
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getOutputSymbols()).addAll(rightPlan.getOutputSymbols()).build();
        ImmutableList.Builder equiClauses = ImmutableList.builder();
        ArrayList<Expression> complexJoinExpressions = new ArrayList<Expression>();
        ArrayList<Expression> postInnerJoinConditions = new ArrayList<Expression>();
        if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
            Expression criteria = this.analysis.getJoinCriteria(node);
            RelationType left = this.analysis.getOutputDescriptor((Node)node.getLeft());
            RelationType right = this.analysis.getOutputDescriptor((Node)node.getRight());
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Type> joinConditionComparisonTypes = new ArrayList<ComparisonExpression.Type>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                if (!this.isEqualComparisonExpression(conjunct = ExpressionUtils.normalize(conjunct)) && node.getType() != Join.Type.INNER) {
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Type comparisonType = ((ComparisonExpression)conjunct).getType();
                    Set<QualifiedName> firstDependencies = DependencyExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = DependencyExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left.canResolvePredicate()) && secondDependencies.stream().allMatch(right.canResolvePredicate())) {
                        leftComparisonExpressions.add(firstExpression);
                        rightComparisonExpressions.add(secondExpression);
                        joinConditionComparisonTypes.add(comparisonType);
                        continue;
                    }
                    if (firstDependencies.stream().allMatch(right.canResolvePredicate()) && secondDependencies.stream().allMatch(left.canResolvePredicate())) {
                        leftComparisonExpressions.add(secondExpression);
                        rightComparisonExpressions.add(firstExpression);
                        joinConditionComparisonTypes.add(comparisonType.flip());
                        continue;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, (Node)node);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, (Node)node);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.symbolAllocator, this.idAllocator);
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonTypes.get(i) == ComparisonExpression.Type.EQUAL) {
                    Symbol leftSymbol = leftPlanBuilder.translate((Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightPlanBuilder.translate((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftComparisonExpressions.get(i));
                Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightComparisonExpressions.get(i));
                postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Type)joinConditionComparisonTypes.get(i), leftExpression, rightExpression));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), Optional.empty(), Optional.empty(), Optional.empty());
        if (node.getType() != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<InPredicate> inPredicates = this.subqueryPlanner.collectInPredicateSubqueries(complexExpression, (Node)node);
                if (inPredicates.isEmpty()) continue;
                InPredicate inPredicate = (InPredicate)Iterables.getLast(inPredicates);
                SemanticExceptions.throwNotSupportedException((Node)inPredicate, "IN with subquery predicate in join condition");
            }
            leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, complexJoinExpressions, (Node)node);
        }
        Optional<Symbol> sampleWeight = Optional.empty();
        RelationPlan intermediateRootRelationPlan = new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols, sampleWeight);
        TranslationMap translationMap = new TranslationMap(intermediateRootRelationPlan, this.analysis);
        translationMap.setFieldMappings((List<Symbol>)outputSymbols);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        if (node.getType() != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            joinedFilterCondition = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)joinedFilterCondition);
            Expression rewritenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), Optional.of(rewritenFilterCondition), Optional.empty(), Optional.empty());
        }
        if (leftPlanBuilder.getSampleWeight().isPresent() || rightPlanBuilder.getSampleWeight().isPresent()) {
            ArithmeticBinaryExpression expression = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Type.MULTIPLY, RelationPlanner.oneIfNull(leftPlanBuilder.getSampleWeight()), RelationPlanner.oneIfNull(rightPlanBuilder.getSampleWeight()));
            sampleWeight = Optional.of(this.symbolAllocator.newSymbol((Expression)expression, (Type)BigintType.BIGINT));
            ImmutableMap.Builder projections = ImmutableMap.builder();
            projections.put((Object)sampleWeight.get(), (Object)expression);
            for (Symbol symbol : ((PlanNode)root).getOutputSymbols()) {
                projections.put((Object)symbol, (Object)symbol.toSymbolReference());
            }
            root = new ProjectNode(this.idAllocator.getNextId(), root, (Map<Symbol, Expression>)projections.build());
        }
        if (node.getType() == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root, sampleWeight, this.analysis.getParameters());
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, (Node)node);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), root, postInnerJoinCriteria);
            }
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols, sampleWeight);
    }

    private boolean isEqualComparisonExpression(Expression conjunct) {
        return conjunct instanceof ComparisonExpression && ((ComparisonExpression)conjunct).getType() == ComparisonExpression.Type.EQUAL;
    }

    private RelationPlan planCrossJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedSymbolsBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            unnestedSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = unnestedSymbolsBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = planBuilder.appendProjections(node.getExpressions(), this.symbolAllocator, this.idAllocator);
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = Types.checkType(planBuilder.getRoot(), ProjectNode.class, "planBuilder.getRoot()");
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        UnmodifiableIterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Symbol inputSymbol = translations.get(expression);
            if (type instanceof ArrayType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next(), (Object)unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), projectNode, leftPlan.getOutputSymbols(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, this.analysis.getScope((Node)joinNode), unnestNode.getOutputSymbols(), Optional.empty());
    }

    private static Expression oneIfNull(Optional<Symbol> symbol) {
        if (symbol.isPresent()) {
            return new CoalesceExpression(new Expression[]{symbol.get().toSymbolReference(), new LongLiteral("1")});
        }
        return new LongLiteral("1");
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        Optional<Double> approximationConfidence = node.getApproximate().map(Approximate::getConfidence).map(confidence -> Double.valueOf(confidence) / 100.0);
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session, approximationConfidence).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session, Optional.empty()).plan(node);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                List items = ((Row)row).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Expression expression = (Expression)items.get(i);
                    expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
                    Object constantValue = ExpressionInterpreter.evaluateConstantExpression(expression, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences(), this.analysis.getParameters());
                    values.add((Object)LiteralInterpreter.toExpression(constantValue, scope.getRelationType().getFieldByIndex(i).getType()));
                }
            } else {
                row = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)row);
                Object constantValue = ExpressionInterpreter.evaluateConstantExpression(row, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences(), this.analysis.getParameters());
                values.add((Object)LiteralInterpreter.toExpression(constantValue, scope.getRelationType().getFieldByIndex(0).getType()));
            }
            rows.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbolsBuilder.build(), (List<List<Expression>>)rows.build());
        return new RelationPlan(valuesNode, scope, (List<Symbol>)outputSymbolsBuilder.build(), Optional.empty());
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = outputSymbolsBuilder.build();
        ImmutableList.Builder argumentSymbols = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        Iterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
            Object constantValue = ExpressionInterpreter.evaluateConstantExpression(expression, this.analysis.getCoercions(), this.metadata, this.session, this.analysis.getColumnReferences(), this.analysis.getParameters());
            Type type = this.analysis.getType(expression);
            values.add((Object)LiteralInterpreter.toExpression(constantValue, type));
            Symbol inputSymbol = this.symbolAllocator.newSymbol(expression, type);
            argumentSymbols.add((Object)inputSymbol);
            if (type instanceof ArrayType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next(), unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)argumentSymbols.build(), (List<List<Expression>>)ImmutableList.of((Object)values.build()));
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), valuesNode, (List<Symbol>)ImmutableList.of(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, scope, (List<Symbol>)unnestedSymbols, Optional.empty());
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, Void context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = (RelationPlan)this.process((Node)node, context);
        if (coerceToTypes == null) {
            return plan;
        }
        return this.addCoercions(plan, coerceToTypes);
    }

    private RelationPlan addCoercions(RelationPlan plan, Type[] targetColumnTypes) {
        List<Symbol> oldSymbols = plan.getOutputSymbols();
        RelationType oldDescriptor = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((targetColumnTypes.length == oldSymbols.size() ? 1 : 0) != 0);
        ImmutableList.Builder newSymbols = new ImmutableList.Builder();
        Field[] newFields = new Field[targetColumnTypes.length];
        ImmutableMap.Builder assignments = new ImmutableMap.Builder();
        for (int i = 0; i < targetColumnTypes.length; ++i) {
            Symbol outputSymbol;
            Symbol inputSymbol = oldSymbols.get(i);
            Type outputType = targetColumnTypes[i];
            Type inputType = this.symbolAllocator.getTypes().get(inputSymbol);
            if (outputType != inputType && !this.metadata.getTypeManager().isTypeOnlyCoercion(inputType, outputType)) {
                Cast cast = new Cast((Expression)inputSymbol.toSymbolReference(), outputType.getTypeSignature().toString());
                outputSymbol = this.symbolAllocator.newSymbol((Expression)cast, outputType);
                assignments.put((Object)outputSymbol, (Object)cast);
                newSymbols.add((Object)outputSymbol);
            } else {
                SymbolReference symbolReference = inputSymbol.toSymbolReference();
                outputSymbol = this.symbolAllocator.newSymbol((Expression)symbolReference, outputType);
                assignments.put((Object)outputSymbol, (Object)symbolReference);
                newSymbols.add((Object)outputSymbol);
            }
            Field oldField = oldDescriptor.getFieldByIndex(i);
            newFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), targetColumnTypes[i], oldField.isHidden());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), (Map<Symbol, Expression>)assignments.build());
        return new RelationPlan(projectNode, Scope.builder().withRelationType(new RelationType(newFields)).build(), (List<Symbol>)newSymbols.build(), plan.getSampleWeight());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), planNode.getOutputSymbols(), setOperationPlan.getOutputSampleWeight());
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), setOperationPlan.getOutputSampleWeight());
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), setOperationPlan.getOutputSampleWeight());
    }

    private SetOperationPlan process(SetOperation node) {
        List outputs = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, null)).collect(ImmutableCollectors.toImmutableList());
        boolean hasSampleWeight = false;
        for (RelationPlan subPlan : subPlans) {
            if (!subPlan.getSampleWeight().isPresent()) continue;
            hasSampleWeight = true;
            break;
        }
        Optional<Object> outputSampleWeight = Optional.empty();
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            if (hasSampleWeight && !relationPlan.getSampleWeight().isPresent()) {
                relationPlan = this.addConstantSampleWeight(relationPlan);
            }
            List<Symbol> childOutputSymbols = relationPlan.getOutputSymbols();
            if (outputs == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    Symbol symbol = childOutputSymbols.get(fieldIndex);
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                outputs = outputSymbolBuilder.build();
                outputSampleWeight = relationPlan.getSampleWeight();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == outputs.size() ? 1 : 0) != 0, (String)"Expected relation to have %s symbols but has %s symbols", (Object[])new Object[]{descriptor.getVisibleFieldCount(), outputs.size()});
            int fieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                symbolMapping.put(outputs.get(fieldId), (Object)childOutputSymbols.get(fieldIndex));
                ++fieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        return new SetOperationPlan((List)sources.build(), (ListMultimap)symbolMapping.build(), outputSampleWeight);
    }

    private RelationPlan addConstantSampleWeight(RelationPlan subPlan) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getOutputSymbols()) {
            projections.put((Object)symbol, (Object)symbol.toSymbolReference());
        }
        LongLiteral one = new LongLiteral("1");
        Symbol sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        projections.put((Object)sampleWeightSymbol, (Object)one);
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build());
        return new RelationPlan(projectNode, subPlan.getScope(), projectNode.getOutputSymbols(), Optional.of(sampleWeightSymbol));
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight(), this.analysis.getParameters());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of(node.getOutputSymbols()), AggregationNode.Step.SINGLE, Optional.empty(), 1.0, Optional.empty(), Optional.empty());
    }

    private static class SetOperationPlan {
        private final List<PlanNode> sources;
        private final ListMultimap<Symbol, Symbol> symbolMapping;
        private final Optional<Symbol> outputSampleWeight;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<Symbol, Symbol> symbolMapping, Optional<Symbol> outputSampleWeight) {
            this.sources = sources;
            this.symbolMapping = symbolMapping;
            this.outputSampleWeight = outputSampleWeight;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public ListMultimap<Symbol, Symbol> getSymbolMapping() {
            return this.symbolMapping;
        }

        public Optional<Symbol> getOutputSampleWeight() {
            return this.outputSampleWeight;
        }
    }
}

