/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class RelationPlan {
    private final PlanNode root;
    private final List<Symbol> outputSymbols;
    private final Scope scope;
    private final Optional<Symbol> sampleWeight;

    public RelationPlan(PlanNode root, Scope scope, List<Symbol> outputSymbols, Optional<Symbol> sampleWeight) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(outputSymbols, "outputSymbols is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(sampleWeight, "sampleWeight is null");
        Preconditions.checkArgument((scope.getRelationType().getAllFieldCount() == outputSymbols.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match scope size (%s)", (Object[])new Object[]{outputSymbols.size(), scope.getRelationType().getAllFieldCount()});
        this.root = root;
        this.scope = scope;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.sampleWeight = sampleWeight;
    }

    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    public Optional<Symbol> getSymbol(Expression expression) {
        return this.scope.tryResolveField(expression).filter(ResolvedField::isLocal).map(field -> this.outputSymbols.get(field.getFieldIndex()));
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.outputSymbols.size() && this.outputSymbols.get(fieldIndex) != null ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (Object[])new Object[]{fieldIndex});
        return this.outputSymbols.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    public RelationType getDescriptor() {
        return this.scope.getRelationType();
    }

    public Scope getScope() {
        return this.scope;
    }
}

