/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.BeginTableWrite;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.optimizations.CountConstantOptimizer;
import com.facebook.presto.sql.planner.optimizations.DesugaringOptimizer;
import com.facebook.presto.sql.planner.optimizations.EmptyDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MergeIdenticalWindows;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.MetadataDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.PartialAggregationPushDown;
import com.facebook.presto.sql.planner.optimizations.PickLayout;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.ProjectionPushDown;
import com.facebook.presto.sql.planner.optimizations.PruneIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.PushTableWriteThroughUnion;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.SingleDistinctOptimizer;
import com.facebook.presto.sql.planner.optimizations.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.optimizations.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.optimizations.TransformUncorrelatedScalarToJoin;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;

public class PlanOptimizers {
    private final List<PlanOptimizer> optimizers;

    @Inject
    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig) {
        this(metadata, sqlParser, featuresConfig, false);
    }

    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig, boolean forceSingleNode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new DesugaringOptimizer(metadata, sqlParser), new ImplementSampleAsFilter(), new CanonicalizeExpressions(), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new PruneIdentityProjections(), new SetFlatteningOptimizer(), new ImplementIntersectAndExceptAsUnion(), new LimitPushDown(), new PruneUnreferencedOutputs(), new MergeProjections(), new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), new TransformUncorrelatedScalarToJoin(), new TransformCorrelatedScalarAggregationToJoin(metadata), new PredicatePushDown(metadata, sqlParser), new MergeProjections(), new SimplifyExpressions(metadata, sqlParser), new ProjectionPushDown(), new UnaliasSymbolReferences(), new PruneUnreferencedOutputs(), new IndexJoinOptimizer(metadata), new CountConstantOptimizer(), new WindowFilterPushDown(metadata), new MergeIdenticalWindows(), new MergeProjections(), new PruneUnreferencedOutputs(), new PruneIdentityProjections(), new MetadataQueryOptimizer(metadata)});
        if (featuresConfig.isOptimizeSingleDistinct()) {
            builder.add((Object)new SingleDistinctOptimizer());
            builder.add((Object)new PruneUnreferencedOutputs());
        }
        if (!forceSingleNode) {
            builder.add((Object)new PushTableWriteThroughUnion());
            builder.add((Object)new AddExchanges(metadata, sqlParser));
        }
        builder.add((Object)new PickLayout(metadata));
        builder.add((Object)new EmptyDeleteOptimizer());
        builder.add((Object)new PredicatePushDown(metadata, sqlParser));
        builder.add((Object)new ProjectionPushDown());
        builder.add((Object)new MergeProjections());
        builder.add((Object)new UnaliasSymbolReferences());
        builder.add((Object)new PruneUnreferencedOutputs());
        builder.add((Object)new PruneIdentityProjections());
        builder.add((Object)new AddLocalExchanges(metadata, sqlParser));
        builder.add((Object)new PartialAggregationPushDown(metadata));
        builder.add((Object)new HashGenerationOptimizer());
        builder.add((Object)new MetadataDeleteOptimizer(metadata));
        builder.add((Object)new BeginTableWrite(metadata));
        this.optimizers = builder.build();
    }

    public List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

