/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class PlanBuilder {
    private final TranslationMap translations;
    private final List<Expression> parameters;
    private final PlanNode root;
    private final Optional<Symbol> sampleWeight;

    public PlanBuilder(TranslationMap translations, PlanNode root, Optional<Symbol> sampleWeight, List<Expression> parameters) {
        Objects.requireNonNull(translations, "translations is null");
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(sampleWeight, "sampleWeight is null");
        Objects.requireNonNull(parameters, "parameterRewriter is null");
        this.translations = translations;
        this.root = root;
        this.sampleWeight = sampleWeight;
        this.parameters = parameters;
    }

    public TranslationMap copyTranslations() {
        TranslationMap translations = new TranslationMap(this.getRelationPlan(), this.getAnalysis());
        translations.copyMappingsFrom(this.getTranslations());
        return translations;
    }

    private Analysis getAnalysis() {
        return this.translations.getAnalysis();
    }

    public PlanBuilder withNewRoot(PlanNode root) {
        return new PlanBuilder(this.translations, root, this.sampleWeight, this.parameters);
    }

    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    public RelationPlan getRelationPlan() {
        return this.translations.getRelationPlan();
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public boolean canTranslate(Expression expression) {
        return this.translations.containsSymbol(expression);
    }

    public Symbol translate(Expression expression) {
        return this.translations.get(expression);
    }

    public Expression rewrite(Expression expression) {
        return this.translations.rewrite(expression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }

    public PlanBuilder appendProjections(Iterable<Expression> expressions, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        TranslationMap translations = this.copyTranslations();
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : this.getRoot().getOutputSymbols()) {
            projections.put((Object)symbol, (Object)symbol.toSymbolReference());
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        ParameterRewriter parameterRewriter = new ParameterRewriter(this.parameters, this.getAnalysis());
        for (Expression expression : expressions) {
            Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)parameterRewriter, (Expression)expression);
            translations.addIntermediateMapping(expression, rewritten);
            Symbol symbol = symbolAllocator.newSymbol(rewritten, this.getAnalysis().getTypeWithCoercions(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(rewritten));
            newTranslations.put((Object)symbol, (Object)rewritten);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(idAllocator.getNextId(), this.getRoot(), (Map<Symbol, Expression>)projections.build()), this.getSampleWeight(), this.parameters);
    }
}

