/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class NodePartitioningManager {
    private final NodeScheduler nodeScheduler;
    private final ConcurrentMap<ConnectorId, ConnectorNodePartitioningProvider> partitioningProviders = new ConcurrentHashMap<ConnectorId, ConnectorNodePartitioningProvider>();

    @Inject
    public NodePartitioningManager(NodeScheduler nodeScheduler) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
    }

    public void addPartitioningProvider(ConnectorId connectorId, ConnectorNodePartitioningProvider partitioningProvider) {
        Preconditions.checkArgument((this.partitioningProviders.putIfAbsent(connectorId, partitioningProvider) == null ? 1 : 0) != 0, (String)"NodePartitioningProvider for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes) {
        Optional<int[]> bucketToPartition = partitioningScheme.getBucketToPartition();
        Preconditions.checkArgument((boolean)bucketToPartition.isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            Preconditions.checkArgument((boolean)partitioningScheme.getBucketToPartition().isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), partitioningScheme.getBucketToPartition().get());
        }
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(partitioningHandle.getConnectorId().get());
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object[])new Object[]{partitioningHandle.getConnectorId().get()});
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle(), partitionChannelTypes, bucketToPartition.get().length);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No function %s", (Object[])new Object[]{partitioningHandle});
        return new PartitionFunction(bucketFunction, partitioningScheme.getBucketToPartition().get());
    }

    public NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getNodePartitionMap(session, this.nodeScheduler);
        }
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(partitioningHandle.getConnectorId().get());
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object[])new Object[]{partitioningHandle.getConnectorId().get()});
        Map bucketToNode = partitioningProvider.getBucketToNode((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((bucketToNode != null ? 1 : 0) != 0, (String)"No partition map %s", (Object[])new Object[]{partitioningHandle});
        Preconditions.checkArgument((!bucketToNode.isEmpty() ? 1 : 0) != 0, (String)"Partition map %s is empty", (Object[])new Object[]{partitioningHandle});
        int bucketCount = bucketToNode.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
        Preconditions.checkArgument((bucketCount < 1000000 ? 1 : 0) != 0, (String)"Too many buckets in partitioning: %s", (Object[])new Object[]{bucketCount});
        int[] bucketToPartition = new int[bucketCount];
        HashBiMap nodeToPartition = HashBiMap.create();
        int nextPartitionId = 0;
        for (Map.Entry entry : bucketToNode.entrySet()) {
            Integer partitionId = (Integer)nodeToPartition.get(entry.getValue());
            if (partitionId == null) {
                partitionId = nextPartitionId++;
                nodeToPartition.put(entry.getValue(), (Object)partitionId);
            }
            bucketToPartition[((Integer)entry.getKey()).intValue()] = partitionId;
        }
        ToIntFunction splitBucketFunction = partitioningProvider.getSplitBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((splitBucketFunction != null ? 1 : 0) != 0, (String)"No partitioning %s", (Object[])new Object[]{partitioningHandle});
        return new NodePartitionMap((Map<Integer, Node>)nodeToPartition.inverse(), bucketToPartition, split -> splitBucketFunction.applyAsInt(split.getConnectorSplit()));
    }
}

