/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.TryCodeGenerator;
import com.facebook.presto.sql.gen.TryExpressionExtractor;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.DeterminismEvaluator;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PageProcessorCompiler
implements BodyCompiler<PageProcessor> {
    private final Metadata metadata;
    private final DeterminismEvaluator determinismEvaluator;

    public PageProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
        this.determinismEvaluator = new DeterminismEvaluator(metadata.getFunctionRegistry());
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        ImmutableList.Builder projectMethods = ImmutableList.builder();
        ImmutableList.Builder projectColumnarMethods = ImmutableList.builder();
        ImmutableList.Builder projectDictionaryMethods = ImmutableList.builder();
        for (int i = 0; i < projections.size(); ++i) {
            MethodDefinition project = this.generateProjectMethod(classDefinition, callSiteBinder, cachedInstanceBinder, "project_" + i, projections.get(i));
            MethodDefinition projectColumnar = PageProcessorCompiler.generateProjectColumnarMethod(classDefinition, callSiteBinder, "projectColumnar_" + i, projections.get(i), project);
            MethodDefinition projectRLE = this.generateProjectRLEMethod(classDefinition, "projectRLE_" + i, projections.get(i), project, projectColumnar);
            MethodDefinition projectDictionary = this.generateProjectDictionaryMethod(classDefinition, "projectDictionary_" + i, projections.get(i), project, projectColumnar, projectRLE);
            projectMethods.add((Object)project);
            projectColumnarMethods.add((Object)projectColumnar);
            projectDictionaryMethods.add((Object)projectDictionary);
        }
        ImmutableList projectMethodDefinitions = projectMethods.build();
        ImmutableList projectColumnarMethodDefinitions = projectColumnarMethods.build();
        ImmutableList projectDictionaryMethodDefinitions = projectDictionaryMethods.build();
        PageProcessorCompiler.generateProcessMethod(classDefinition, filter, projections, (List<MethodDefinition>)projectMethodDefinitions);
        PageProcessorCompiler.generateGetNonLazyPageMethod(classDefinition, filter, projections);
        PageProcessorCompiler.generateProcessColumnarMethod(classDefinition, projections, (List<MethodDefinition>)projectColumnarMethodDefinitions);
        PageProcessorCompiler.generateProcessColumnarDictionaryMethod(classDefinition, projections, (List<MethodDefinition>)projectDictionaryMethodDefinitions);
        this.generateFilterPageMethod(classDefinition, filter);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filter);
        PageProcessorCompiler.generateConstructor(classDefinition, cachedInstanceBinder, projections.size());
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder, int projectionCount) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        FieldDefinition inputDictionaries = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "inputDictionaries", Block[].class);
        FieldDefinition outputDictionaries = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "outputDictionaries", Block[].class);
        FieldDefinition inputFilterDictionary = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "inputFilterDictionary", Block.class);
        FieldDefinition filterResult = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "filterResult", boolean[].class);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(inputDictionaries, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)projectionCount)));
        body.append((BytecodeNode)thisVariable.setField(outputDictionaries, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)projectionCount)));
        body.append((BytecodeNode)thisVariable.setField(inputFilterDictionary, BytecodeExpressions.constantNull(Block.class)));
        body.append((BytecodeNode)thisVariable.setField(filterResult, BytecodeExpressions.constantNull(boolean[].class)));
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections, List<MethodDefinition> projectionMethods) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter start = Parameter.arg((String)"start", Integer.TYPE);
        Parameter end = Parameter.arg((String)"end", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(Integer.TYPE), new Parameter[]{session, page, start, end, pageBuilder});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int channel : allInputChannels) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
            builder.put((Object)channel, (Object)blockVariable);
        }
        ImmutableMap channelBlocks = builder.build();
        Map<RowExpression, List<Variable>> expressionInputBlocks = PageProcessorCompiler.getExpressionInputBlocks(projections, filter, (Map<Integer, Variable>)channelBlocks);
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        BytecodeBlock project = new BytecodeBlock().append((BytecodeNode)pageBuilder.invoke("declarePosition", Void.TYPE, new BytecodeExpression[0]));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            RowExpression projection = projections.get(projectionIndex);
            project.append(PageProcessorCompiler.invokeProject(thisVariable, (Variable)session, expressionInputBlocks.get(projection), (BytecodeExpression)position, (Variable)pageBuilder, BytecodeExpressions.constantInt((int)projectionIndex), projectionMethods.get(projectionIndex)));
        }
        LabelNode done = new LabelNode("done");
        ForLoop loop = new ForLoop().initialize((BytecodeNode)position.set((BytecodeExpression)start)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)end)).update((BytecodeNode)position.set(BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1)))).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)new IfStatement().condition((BytecodeNode)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)done))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)PageProcessorCompiler.invokeFilter((BytecodeExpression)thisVariable, (BytecodeExpression)session, expressionInputBlocks.get(filter), (BytecodeExpression)position)).ifTrue((BytecodeNode)project)));
        body.append((BytecodeNode)loop).visitLabel(done).append((BytecodeNode)position.ret());
    }

    private static void generateProcessColumnarMethod(ClassDefinition classDefinition, List<RowExpression> projections, List<MethodDefinition> projectColumnarMethods) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter types = Parameter.arg((String)"types", List.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "processColumnar", ParameterizedType.type(Page.class), new Parameter[]{session, page, types});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.invoke("filterPage", int[].class, new BytecodeExpression[]{session, page}));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        body.comment("if no rows selected return null").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)cardinality, (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)BytecodeExpressions.constantNull(Page.class).ret()));
        if (projections.isEmpty()) {
            body.append((BytecodeNode)BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)0)}).ret());
            return;
        }
        Variable pageBuilder = scope.declareVariable("pageBuilder", body, BytecodeExpressions.newInstance(PageBuilder.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, types}));
        Variable outputBlocks = scope.declareVariable("outputBlocks", body, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)projections.size()));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)BytecodeExpressions.constantInt((int)projectionIndex)).build();
            body.append((BytecodeNode)outputBlocks.setElement(projectionIndex, thisVariable.invoke(projectColumnarMethods.get(projectionIndex), (Iterable)params)));
        }
        body.append((BytecodeNode)BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, outputBlocks}).ret());
    }

    private static MethodDefinition generateProjectColumnarMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection, MethodDefinition projectionMethod) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", int[].class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter projectionIndex = Parameter.arg((String)"projectionIndex", Integer.TYPE);
        ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).build();
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), methodName, ParameterizedType.type(Block.class), (Iterable)params);
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int channel : PageProcessorCompiler.getInputChannels(projection)) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
            builder.add((Object)blockVariable);
        }
        ImmutableList inputs = builder.build();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        Variable position = scope.declareVariable("position", body, BytecodeExpressions.constantInt((int)0));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        Variable outputBlock = scope.declareVariable(Block.class, "outputBlock");
        Variable blockBuilder = scope.declareVariable("blockBuilder", body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{projectionIndex}));
        Variable type = scope.declareVariable("type", body, pageBuilder.invoke("getType", Type.class, new BytecodeExpression[]{projectionIndex}));
        BytecodeBlock projectBlock = new BytecodeBlock().append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)cardinality)).update((BytecodeNode)position.increment()).body(PageProcessorCompiler.invokeProject(thisVariable, (Variable)session, (List<? extends Variable>)inputs, selectedPositions.getElement((BytecodeExpression)position), (Variable)pageBuilder, (BytecodeExpression)projectionIndex, projectionMethod))).append((BytecodeNode)outputBlock.set(blockBuilder.invoke("build", Block.class, new BytecodeExpression[0])));
        if (PageProcessorCompiler.isIdentityExpression(projection)) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)cardinality, (BytecodeExpression)positionCount)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)((Variable)inputs.get(0)).invoke("assureLoaded", Void.TYPE, new BytecodeExpression[0])).append((BytecodeNode)outputBlock.set((BytecodeExpression)inputs.get(0)))).ifFalse((BytecodeNode)projectBlock));
        } else if (PageProcessorCompiler.isConstantExpression(projection)) {
            ConstantExpression constantExpression = (ConstantExpression)projection;
            Verify.verify((boolean)PageProcessorCompiler.getInputChannels(projection).isEmpty());
            BytecodeExpression value = BytecodeUtils.loadConstant(callSiteBinder, constantExpression.getValue(), Object.class);
            body.append((BytecodeNode)outputBlock.set(BytecodeExpressions.invokeStatic(RunLengthEncodedBlock.class, (String)"create", Block.class, (BytecodeExpression[])new BytecodeExpression[]{type, value, cardinality})));
        } else {
            body.append((BytecodeNode)projectBlock);
        }
        body.append((BytecodeNode)outputBlock.ret());
        return method;
    }

    private MethodDefinition generateProjectRLEMethod(ClassDefinition classDefinition, String methodName, RowExpression projection, MethodDefinition projectionMethod, MethodDefinition projectColumnar) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", int[].class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter projectionIndex = Parameter.arg((String)"projectionIndex", Integer.TYPE);
        ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).build();
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), methodName, ParameterizedType.type(Block.class), (Iterable)params);
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        List<Integer> inputChannels = PageProcessorCompiler.getInputChannels(projection);
        if (inputChannels.size() != 1 || !this.determinismEvaluator.isDeterministic(projection)) {
            body.append((BytecodeNode)thisVariable.invoke(projectColumnar, (Iterable)params).ret());
            return method;
        }
        Variable inputBlock = scope.declareVariable("inputBlock", body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)((Integer)Iterables.getOnlyElement(inputChannels)))}));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)inputBlock.instanceOf(RunLengthEncodedBlock.class)).ifFalse((BytecodeNode)thisVariable.invoke(projectColumnar, (Iterable)params).ret()));
        Variable valueBlock = scope.declareVariable("valueBlock", body, inputBlock.cast(RunLengthEncodedBlock.class).invoke("getValue", Block.class, new BytecodeExpression[0]));
        Variable blockBuilder = scope.declareVariable("blockBuilder", body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{projectionIndex}));
        body.append(PageProcessorCompiler.invokeProject(thisVariable, (Variable)session, Collections.singletonList(valueBlock), BytecodeExpressions.constantInt((int)0), (Variable)pageBuilder, (BytecodeExpression)projectionIndex, projectionMethod));
        Variable outputValueBlock = scope.declareVariable("outputValueBlock", body, blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]));
        body.append((BytecodeNode)BytecodeExpressions.newInstance(RunLengthEncodedBlock.class, (BytecodeExpression[])new BytecodeExpression[]{outputValueBlock, selectedPositions.length()}).ret());
        return method;
    }

    private MethodDefinition generateProjectDictionaryMethod(ClassDefinition classDefinition, String methodName, RowExpression projection, MethodDefinition project, MethodDefinition projectColumnar, MethodDefinition projectRLE) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", int[].class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter projectionIndex = Parameter.arg((String)"projectionIndex", Integer.TYPE);
        Parameter dictionarySourceIds = Parameter.arg((String)"dictionarySourceIds", Map.class);
        ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).add((Object)dictionarySourceIds).build();
        ImmutableList columnarParams = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)projectionIndex).build();
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), methodName, ParameterizedType.type(Block.class), (Iterable)params);
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        List<Integer> inputChannels = PageProcessorCompiler.getInputChannels(projection);
        if (inputChannels.size() != 1 || !this.determinismEvaluator.isDeterministic(projection)) {
            body.append((BytecodeNode)thisVariable.invoke(projectColumnar, (Iterable)columnarParams).ret());
            return method;
        }
        Variable inputBlock = scope.declareVariable("inputBlock", body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)((Integer)Iterables.getOnlyElement(inputChannels)))}));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)inputBlock.instanceOf(RunLengthEncodedBlock.class)).ifTrue((BytecodeNode)thisVariable.invoke(projectRLE, (Iterable)columnarParams).ret()));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)inputBlock.instanceOf(DictionaryBlock.class)).ifFalse((BytecodeNode)thisVariable.invoke(projectColumnar, (Iterable)columnarParams).ret()));
        Variable blockBuilder = scope.declareVariable("blockBuilder", body, pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{projectionIndex}));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        Variable dictionary = scope.declareVariable(Block.class, "dictionary");
        Variable ids = scope.declareVariable(Slice.class, "ids");
        Variable dictionaryCount = scope.declareVariable(Integer.TYPE, "dictionaryCount");
        Variable inputSourceId = scope.declareVariable(DictionaryId.class, "inputSourceId");
        Variable outputSourceId = scope.declareVariable(DictionaryId.class, "outputSourceId");
        Variable outputDictionary = scope.declareVariable(Block.class, "outputDictionary");
        Variable outputIds = scope.declareVariable(int[].class, "outputIds");
        BytecodeExpression inputDictionaries = thisVariable.getField("inputDictionaries", Block[].class);
        BytecodeExpression outputDictionaries = thisVariable.getField("outputDictionaries", Block[].class);
        Variable position = scope.declareVariable("position", body, BytecodeExpressions.constantInt((int)0));
        BytecodeExpression castDictionaryBlock = inputBlock.cast(DictionaryBlock.class);
        body.comment("Extract dictionary, ids, positionCount and dictionarySourceId").append((BytecodeNode)dictionary.set(castDictionaryBlock.invoke("getDictionary", Block.class, new BytecodeExpression[0]))).append((BytecodeNode)ids.set(castDictionaryBlock.invoke("getIds", Slice.class, new BytecodeExpression[0]))).append((BytecodeNode)dictionaryCount.set(dictionary.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)inputSourceId.set(castDictionaryBlock.invoke("getDictionarySourceId", DictionaryId.class, new BytecodeExpression[0])));
        BytecodeBlock projectDictionary = new BytecodeBlock().comment("Project dictionary").append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)dictionaryCount)).update((BytecodeNode)position.increment()).body(PageProcessorCompiler.invokeProject(thisVariable, (Variable)session, (List<? extends Variable>)ImmutableList.of((Object)dictionary), (BytecodeExpression)position, (Variable)pageBuilder, (BytecodeExpression)projectionIndex, project))).append((BytecodeNode)outputDictionary.set(blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]))).append((BytecodeNode)inputDictionaries.setElement((BytecodeExpression)projectionIndex, (BytecodeExpression)dictionary)).append((BytecodeNode)outputDictionaries.setElement((BytecodeExpression)projectionIndex, (BytecodeExpression)outputDictionary));
        body.comment("Use processed dictionary, if available, else project it").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)inputDictionaries.getElement((BytecodeExpression)projectionIndex), (BytecodeExpression)dictionary)).ifTrue((BytecodeNode)outputDictionary.set(outputDictionaries.getElement((BytecodeExpression)projectionIndex))).ifFalse((BytecodeNode)projectDictionary));
        body.comment("Filter ids").append((BytecodeNode)outputIds.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(int[].class), (BytecodeExpression)cardinality))).append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)cardinality)).update((BytecodeNode)position.increment()).body((BytecodeNode)outputIds.setElement((BytecodeExpression)position, castDictionaryBlock.invoke("getId", Integer.TYPE, new BytecodeExpression[]{selectedPositions.getElement((BytecodeExpression)position)}))));
        body.append((BytecodeNode)outputSourceId.set(dictionarySourceIds.invoke("get", Object.class, new BytecodeExpression[]{inputSourceId.cast(Object.class)}).cast(DictionaryId.class)));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)outputSourceId, (BytecodeExpression)BytecodeExpressions.constantNull(DictionaryId.class))).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)outputSourceId.set(BytecodeExpressions.invokeStatic(DictionaryId.class, (String)"randomDictionaryId", DictionaryId.class, (BytecodeExpression[])new BytecodeExpression[0]))).append((BytecodeNode)dictionarySourceIds.invoke("put", Object.class, new BytecodeExpression[]{inputSourceId.cast(Object.class), outputSourceId.cast(Object.class)})).pop()));
        BytecodeExpression idsSlice = BytecodeExpressions.invokeStatic(Slices.class, (String)"wrappedIntArray", Slice.class, (BytecodeExpression[])new BytecodeExpression[]{outputIds});
        body.append((BytecodeNode)BytecodeExpressions.newInstance(DictionaryBlock.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, outputDictionary, idsSlice, BytecodeExpressions.constantFalse(), outputSourceId}).cast(Block.class).ret());
        return method;
    }

    private static void generateProcessColumnarDictionaryMethod(ClassDefinition classDefinition, List<RowExpression> projections, List<MethodDefinition> projectDictionaryMethods) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter types = Parameter.arg((String)"types", List.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "processColumnarDictionary", ParameterizedType.type(Page.class), new Parameter[]{session, page, types});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.invoke("filterPage", int[].class, new BytecodeExpression[]{session, page}));
        Variable cardinality = scope.declareVariable("cardinality", body, selectedPositions.length());
        Variable dictionarySourceIds = scope.declareVariable(ParameterizedType.type(Map.class, (Class[])new Class[]{DictionaryId.class, DictionaryId.class}), "dictionarySourceIds");
        body.append((BytecodeNode)dictionarySourceIds.set(BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.type(HashMap.class, (Class[])new Class[]{DictionaryId.class, DictionaryId.class}), (BytecodeExpression[])new BytecodeExpression[0])));
        body.comment("if no rows selected return null").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)cardinality, (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)BytecodeExpressions.constantNull(Page.class).ret()));
        if (projections.isEmpty()) {
            body.append((BytecodeNode)BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)0)}).ret());
            return;
        }
        Variable pageBuilder = scope.declareVariable("pageBuilder", body, BytecodeExpressions.newInstance(PageBuilder.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, types}));
        body.append((BytecodeNode)page.set(thisVariable.invoke("getNonLazyPage", Page.class, new BytecodeExpression[]{page})));
        Variable outputBlocks = scope.declareVariable("outputBlocks", body, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)projections.size()));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            ImmutableList params = ImmutableList.builder().add((Object)session).add((Object)page).add((Object)selectedPositions).add((Object)pageBuilder).add((Object)BytecodeExpressions.constantInt((int)projectionIndex)).add((Object)dictionarySourceIds).build();
            body.append((BytecodeNode)outputBlocks.setElement(projectionIndex, thisVariable.invoke(projectDictionaryMethods.get(projectionIndex), (Iterable)params)));
        }
        body.append((BytecodeNode)BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{cardinality, outputBlocks}).ret());
    }

    private static void generateGetNonLazyPageMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections) {
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), "getNonLazyPage", ParameterizedType.type(Page.class), new Parameter[]{page});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        if (allInputChannels.isEmpty()) {
            body.append((BytecodeNode)page.ret());
            return;
        }
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        Variable channelCount = scope.declareVariable("channelCount", body, page.invoke("getChannelCount", Integer.TYPE, new BytecodeExpression[0]));
        Variable blocks = scope.declareVariable("blocks", body, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (BytecodeExpression)channelCount));
        Variable inputBlock = scope.declareVariable(Block.class, "inputBlock");
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        Variable createNewPage = scope.declareVariable("createNewPage", body, BytecodeExpressions.constantFalse());
        ForLoop forLoop = new ForLoop().initialize((BytecodeNode)index.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)channelCount)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)inputBlock.set(page.invoke("getBlock", Block.class, new BytecodeExpression[]{index}))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)inputBlock.instanceOf(LazyBlock.class)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blocks.setElement((BytecodeExpression)index, inputBlock.cast(LazyBlock.class).invoke("getBlock", Block.class, new BytecodeExpression[0]))).append((BytecodeNode)createNewPage.set(BytecodeExpressions.constantTrue()))).ifFalse((BytecodeNode)blocks.setElement((BytecodeExpression)index, (BytecodeExpression)inputBlock))));
        body.append((BytecodeNode)forLoop);
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)createNewPage).ifTrue((BytecodeNode)page.set(BytecodeExpressions.newInstance(Page.class, (BytecodeExpression[])new BytecodeExpression[]{positionCount, blocks}))));
        body.append((BytecodeNode)page.ret());
    }

    private void generateFilterPageMethod(ClassDefinition classDefinition, RowExpression filter) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filterPage", ParameterizedType.type(int[].class), new Parameter[]{session, page});
        method.comment("Filter: %s rows in the page", new Object[]{filter.toString()});
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(int[].class), (BytecodeExpression)positionCount));
        Variable selectedCount = scope.declareVariable("selectedCount", body, BytecodeExpressions.constantInt((int)0));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        List<Integer> filterChannels = PageProcessorCompiler.getInputChannels(filter);
        ImmutableList.Builder blockVariablesBuilder = ImmutableList.builder();
        for (int channel : filterChannels) {
            Variable blockVariable = scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
            blockVariablesBuilder.add((Object)blockVariable);
        }
        ImmutableList blockVariables = blockVariablesBuilder.build();
        if (filterChannels.size() == 1 && this.determinismEvaluator.isDeterministic(filter)) {
            BytecodeBlock ifFilterOnDictionaryBlock = PageProcessorCompiler.getBytecodeFilterOnDictionary(session, scope, (Variable)blockVariables.get(0));
            BytecodeBlock ifFilterOnRLEBlock = PageProcessorCompiler.getBytecodeFilterOnRLE(session, scope, (Variable)blockVariables.get(0));
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)((Variable)blockVariables.get(0)).instanceOf(DictionaryBlock.class)).ifTrue((BytecodeNode)ifFilterOnDictionaryBlock));
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)((Variable)blockVariables.get(0)).instanceOf(RunLengthEncodedBlock.class)).ifTrue((BytecodeNode)ifFilterOnRLEBlock));
        }
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)PageProcessorCompiler.invokeFilter((BytecodeExpression)thisVariable, (BytecodeExpression)session, (List<? extends BytecodeExpression>)blockVariables, (BytecodeExpression)position)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)selectedPositions.setElement((BytecodeExpression)selectedCount, (BytecodeExpression)position)).append((BytecodeNode)selectedCount.increment()))));
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Arrays.class, (String)"copyOf", int[].class, (BytecodeExpression[])new BytecodeExpression[]{selectedPositions, selectedCount}).ret());
    }

    private static BytecodeBlock getBytecodeFilterOnRLE(Parameter session, Scope scope, Variable blockVariable) {
        Variable positionCount = scope.getVariable("positionCount");
        Variable thisVariable = scope.getThis();
        BytecodeBlock ifFilterOnRLEBlock = new BytecodeBlock();
        Variable rleBlock = scope.declareVariable("rleBlock", ifFilterOnRLEBlock, blockVariable.cast(RunLengthEncodedBlock.class));
        Variable rleValue = scope.declareVariable("rleValue", ifFilterOnRLEBlock, rleBlock.invoke("getValue", Block.class, new BytecodeExpression[0]));
        ifFilterOnRLEBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)PageProcessorCompiler.invokeFilter((BytecodeExpression)thisVariable, (BytecodeExpression)session, Collections.singletonList(rleValue), BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)BytecodeExpressions.invokeStatic(IntStream.class, (String)"range", IntStream.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), positionCount}).invoke("toArray", int[].class, new BytecodeExpression[0]).ret()).ifFalse((BytecodeNode)BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(int[].class), (BytecodeExpression)BytecodeExpressions.constantInt((int)0)).ret()));
        return ifFilterOnRLEBlock;
    }

    private static BytecodeBlock getBytecodeFilterOnDictionary(Parameter session, Scope scope, Variable blockVariable) {
        Variable position = scope.getVariable("position");
        Variable positionCount = scope.getVariable("positionCount");
        Variable selectedCount = scope.getVariable("selectedCount");
        Variable selectedPositions = scope.getVariable("selectedPositions");
        Variable thisVariable = scope.getThis();
        BytecodeExpression inputFilterDictionary = thisVariable.getField("inputFilterDictionary", Block.class);
        BytecodeExpression filterResult = thisVariable.getField("filterResult", boolean[].class);
        BytecodeBlock ifFilterOnDictionaryBlock = new BytecodeBlock();
        Variable dictionaryBlock = scope.declareVariable("dictionaryBlock", ifFilterOnDictionaryBlock, blockVariable.cast(DictionaryBlock.class));
        Variable dictionary = scope.declareVariable("dictionary", ifFilterOnDictionaryBlock, dictionaryBlock.invoke("getDictionary", Block.class, new BytecodeExpression[0]));
        Variable dictionaryPositionCount = scope.declareVariable("dictionaryPositionCount", ifFilterOnDictionaryBlock, dictionary.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        Variable selectedDictionaryPositions = scope.declareVariable("selectedDictionaryPositions", ifFilterOnDictionaryBlock, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (BytecodeExpression)dictionaryPositionCount));
        ifFilterOnDictionaryBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)dictionary, (BytecodeExpression)inputFilterDictionary)).ifTrue((BytecodeNode)selectedDictionaryPositions.set(filterResult)).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)dictionaryPositionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)selectedDictionaryPositions.setElement((BytecodeExpression)position, PageProcessorCompiler.invokeFilter((BytecodeExpression)thisVariable, (BytecodeExpression)session, Collections.singletonList(dictionary), (BytecodeExpression)position)))).append((BytecodeNode)thisVariable.setField("inputFilterDictionary", (BytecodeExpression)dictionary)).append((BytecodeNode)thisVariable.setField("filterResult", (BytecodeExpression)selectedDictionaryPositions))));
        ifFilterOnDictionaryBlock.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)selectedDictionaryPositions.getElement(dictionaryBlock.invoke("getId", Integer.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)selectedPositions.setElement((BytecodeExpression)selectedCount, (BytecodeExpression)position)).append((BytecodeNode)selectedCount.increment()))));
        ifFilterOnDictionaryBlock.append((BytecodeNode)BytecodeExpressions.invokeStatic(Arrays.class, (String)"copyOf", int[].class, (BytecodeExpression[])new BytecodeExpression[]{selectedPositions, selectedCount}).ret());
        return ifFilterOnDictionaryBlock;
    }

    private Map<CallExpression, MethodDefinition> generateTryMethods(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression projection, String methodPrefix) {
        TryExpressionExtractor tryExtractor = new TryExpressionExtractor();
        projection.accept(tryExtractor, null);
        List<CallExpression> tryExpressions = tryExtractor.getTryExpressionsPreOrder();
        ImmutableMap.Builder tryMethodMap = ImmutableMap.builder();
        int methodId = 0;
        for (CallExpression tryExpression : tryExpressions) {
            Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
            List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(tryExpression.getArguments()));
            Parameter position = Parameter.arg((String)"position", Integer.TYPE);
            Parameter wasNullVariable = Parameter.arg((String)"wasNull", Boolean.TYPE);
            BytecodeExpressionVisitor innerExpressionVisitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)position, (Variable)wasNullVariable), this.metadata.getFunctionRegistry(), (Map<CallExpression, MethodDefinition>)tryMethodMap.build());
            ImmutableList inputParameters = ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).add((Object)wasNullVariable).build();
            MethodDefinition tryMethod = TryCodeGenerator.defineTryMethod(innerExpressionVisitor, containerClassDefinition, methodPrefix + "_try_" + methodId, (List<Parameter>)inputParameters, Primitives.wrap((Class)tryExpression.getType().getJavaType()), tryExpression, callSiteBinder);
            tryMethodMap.put((Object)tryExpression, (Object)tryMethod);
            ++methodId;
        }
        return tryMethodMap.build();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression filter) {
        Map<CallExpression, MethodDefinition> tryMethodMap = this.generateTryMethods(classDefinition, callSiteBinder, cachedInstanceBinder, filter, "filter");
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(filter));
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).build());
        method.comment("Filter: %s", new Object[]{filter.toString()});
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)position, wasNullVariable), this.metadata.getFunctionRegistry(), tryMethodMap);
        BytecodeNode visitorBody = filter.accept(visitor, scope);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(visitorBody).putVariable(result).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()).ifFalse((BytecodeNode)result.ret()));
    }

    private MethodDefinition generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, String methodName, RowExpression projection) {
        Map<CallExpression, MethodDefinition> tryMethodMap = this.generateTryMethods(classDefinition, callSiteBinder, cachedInstanceBinder, projection, methodName);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(projection));
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        Parameter output = Parameter.arg((String)"output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).add((Object)output).build());
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)position, wasNullVariable), this.metadata.getFunctionRegistry(), tryMethodMap);
        body.getVariable((Variable)output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(BytecodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
        return method;
    }

    private static boolean isIdentityExpression(RowExpression expression) {
        List<RowExpression> rowExpressions = Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
        return rowExpressions.size() == 1 && Iterables.getOnlyElement(rowExpressions) instanceof InputReferenceExpression;
    }

    private static boolean isConstantExpression(RowExpression expression) {
        List<RowExpression> rowExpressions = Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
        return rowExpressions.size() == 1 && Iterables.getOnlyElement(rowExpressions) instanceof ConstantExpression && ((ConstantExpression)Iterables.getOnlyElement(rowExpressions)).getValue() != null;
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageProcessorCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg((String)("block_" + channel), Block.class));
        }
        return parameters.build();
    }

    private static RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler(CallSiteBinder callSiteBinder, Variable positionVariable, Variable wasNullVariable) {
        return new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> positionVariable, wasNullVariable, callSiteBinder);
    }

    private static Map<RowExpression, List<Variable>> getExpressionInputBlocks(List<RowExpression> projections, RowExpression filter, Map<Integer, Variable> channelBlock) {
        HashMap<RowExpression, List<Variable>> inputBlocksBuilder = new HashMap<RowExpression, List<Variable>>();
        for (RowExpression projection : projections) {
            List inputBlocks = PageProcessorCompiler.getInputChannels(projection).stream().map(channelBlock::get).collect(Collectors.toList());
            List existingVariables = (List)inputBlocksBuilder.get(projection);
            Preconditions.checkState((existingVariables == null || existingVariables.equals(inputBlocks) ? 1 : 0) != 0, (Object)"malformed RowExpression");
            inputBlocksBuilder.put(projection, inputBlocks);
        }
        List filterBlocks = PageProcessorCompiler.getInputChannels(filter).stream().map(channelBlock::get).collect(Collectors.toList());
        inputBlocksBuilder.put(filter, filterBlocks);
        return inputBlocksBuilder;
    }

    private static BytecodeExpression invokeFilter(BytecodeExpression objRef, BytecodeExpression session, List<? extends BytecodeExpression> blockVariables, BytecodeExpression position) {
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).build();
        return objRef.invoke("filter", Boolean.TYPE, (Iterable)params);
    }

    private static BytecodeNode invokeProject(Variable objRef, Variable session, List<? extends Variable> blockVariables, BytecodeExpression position, Variable pageBuilder, BytecodeExpression projectionIndex, MethodDefinition projectionMethod) {
        BytecodeExpression blockBuilder = pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{projectionIndex});
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).add((Object)blockBuilder).build();
        return new BytecodeBlock().append((BytecodeNode)objRef.invoke(projectionMethod, (Iterable)params));
    }
}

