/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.TryCodeGenerator;
import com.facebook.presto.sql.gen.TryExpressionExtractor;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JoinFilterFunctionCompiler {
    private final Metadata metadata;
    private final LoadingCache<JoinFilterCacheKey, Class<? extends JoinFilterFunction>> joinFilterFunctions = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinFilterCacheKey, Class<? extends JoinFilterFunction>>(){

        public Class<? extends JoinFilterFunction> load(JoinFilterCacheKey key) throws Exception {
            return JoinFilterFunctionCompiler.this.compileFilterFunctionInternal(key.getFilter(), key.getLeftBlocksSize());
        }
    });

    @Inject
    public JoinFilterFunctionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    public JoinFilterFunctionFactory compileJoinFilterFunction(RowExpression filter, int leftBlocksSize) {
        Class joinFilterFunction = (Class)this.joinFilterFunctions.getUnchecked((Object)new JoinFilterCacheKey(filter, leftBlocksSize));
        return session -> {
            try {
                return (JoinFilterFunction)joinFilterFunction.getConstructor(ConnectorSession.class).newInstance(session);
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private Class<? extends JoinFilterFunction> compileFilterFunctionInternal(RowExpression filterExpression, int leftBlocksSize) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"JoinFilterFunction"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(JoinFilterFunction.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        new JoinFilterFunctionCompiler(this.metadata).generateMethods(classDefinition, callSiteBinder, filterExpression, leftBlocksSize);
        JoinFilterFunctionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filterExpression).add("leftBlocksSize", leftBlocksSize).toString());
        return CompilerUtils.defineClass((ClassDefinition)classDefinition, JoinFilterFunction.class, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, int leftBlocksSize) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        FieldDefinition sessionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "session", ConnectorSession.class);
        this.generateConstructor(classDefinition, sessionField);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filter, leftBlocksSize, sessionField);
    }

    private void generateConstructor(ClassDefinition classDefinition, FieldDefinition sessionField) {
        Parameter sessionParameter = Parameter.arg((String)"session", ConnectorSession.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{sessionParameter});
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(sessionField, (BytecodeExpression)sessionParameter));
        body.ret();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression filter, int leftBlocksSize, FieldDefinition sessionField) {
        Map<CallExpression, MethodDefinition> tryMethodMap = this.generateTryMethods(classDefinition, callSiteBinder, cachedInstanceBinder, leftBlocksSize, filter);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftBlocks = Parameter.arg((String)"leftBlocks", Block[].class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightBlocks = Parameter.arg((String)"rightBlocks", Block[].class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)leftPosition).add((Object)leftBlocks).add((Object)rightPosition).add((Object)rightBlocks).build());
        method.comment("filter: %s", new Object[]{filter.toString()});
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        scope.declareVariable("session", body, method.getThis().getField(sessionField));
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, JoinFilterFunctionCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)leftPosition, (Variable)leftBlocks, (Variable)rightPosition, (Variable)rightBlocks, leftBlocksSize, wasNullVariable), this.metadata.getFunctionRegistry(), tryMethodMap);
        BytecodeNode visitorBody = filter.accept(visitor, scope);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(visitorBody).putVariable(result).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()).ifFalse((BytecodeNode)result.ret()));
    }

    private Map<CallExpression, MethodDefinition> generateTryMethods(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, int leftBlocksSize, RowExpression filter) {
        TryExpressionExtractor tryExtractor = new TryExpressionExtractor();
        filter.accept(tryExtractor, null);
        List<CallExpression> tryExpressions = tryExtractor.getTryExpressionsPreOrder();
        ImmutableMap.Builder tryMethodMap = ImmutableMap.builder();
        int methodId = 0;
        for (CallExpression tryExpression : tryExpressions) {
            Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
            Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
            Parameter leftBlocks = Parameter.arg((String)"leftBlocks", Block[].class);
            Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
            Parameter rightBlocks = Parameter.arg((String)"rightBlocks", Block[].class);
            Parameter wasNullVariable = Parameter.arg((String)"wasNull", Boolean.TYPE);
            BytecodeExpressionVisitor innerExpressionVisitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, JoinFilterFunctionCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)leftPosition, (Variable)leftBlocks, (Variable)rightPosition, (Variable)rightBlocks, leftBlocksSize, (Variable)wasNullVariable), this.metadata.getFunctionRegistry(), (Map<CallExpression, MethodDefinition>)tryMethodMap.build());
            ImmutableList inputParameters = ImmutableList.builder().add((Object)session).add((Object)leftPosition).add((Object)leftBlocks).add((Object)rightPosition).add((Object)rightBlocks).add((Object)wasNullVariable).build();
            MethodDefinition tryMethod = TryCodeGenerator.defineTryMethod(innerExpressionVisitor, containerClassDefinition, "try_" + methodId, (List<Parameter>)inputParameters, Primitives.wrap((Class)tryExpression.getType().getJavaType()), tryExpression, callSiteBinder);
            tryMethodMap.put((Object)tryExpression, (Object)tryMethod);
            ++methodId;
        }
        return tryMethodMap.build();
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append(BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler(CallSiteBinder callSiteBinder, Variable leftPosition, Variable leftBlocks, Variable rightPosition, Variable rightBlocks, int leftBlocksSize, Variable wasNullVariable) {
        return new InputReferenceCompiler((scope, field) -> field < leftBlocksSize ? leftBlocks.getElement(field.intValue()) : rightBlocks.getElement(field - leftBlocksSize), (scope, field) -> field < leftBlocksSize ? leftPosition : rightPosition, wasNullVariable, callSiteBinder);
    }

    private static final class JoinFilterCacheKey {
        private final RowExpression filter;
        private final int leftBlocksSize;

        public JoinFilterCacheKey(RowExpression filter, int leftBlocksSize) {
            this.filter = Objects.requireNonNull(filter, "filter can not be null");
            this.leftBlocksSize = leftBlocksSize;
        }

        public RowExpression getFilter() {
            return this.filter;
        }

        public int getLeftBlocksSize() {
            return this.leftBlocksSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinFilterCacheKey that = (JoinFilterCacheKey)o;
            return this.leftBlocksSize == that.leftBlocksSize && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.leftBlocksSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("leftBlocksSize", this.leftBlocksSize).toString();
        }
    }

    @FunctionalInterface
    public static interface JoinFilterFunctionFactory {
        public JoinFilterFunction create(ConnectorSession var1);
    }
}

