/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class IsDistinctFromCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        Variable wasNull = generatorContext.wasNull();
        RowExpression left = arguments.get(0);
        RowExpression right = arguments.get(1);
        Type leftType = left.getType();
        Type rightType = right.getType();
        Signature equalsSignature = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
        MethodHandle methodHandle = generatorContext.getRegistry().getScalarFunctionImplementation(equalsSignature).getMethodHandle();
        Binding binding = generatorContext.getCallSiteBinder().bind(methodHandle);
        BytecodeBlock equalsCall = new BytecodeBlock().comment("equals(%s, %s)", new Object[]{leftType, rightType}).append(BytecodeUtils.invoke(binding, equalsSignature));
        BytecodeBlock neitherSideIsNull = leftType instanceof UnknownType || rightType instanceof UnknownType ? new BytecodeBlock().comment("unreachable code").pop(rightType.getJavaType()).pop(leftType.getJavaType()).push(false) : new BytecodeBlock().append((BytecodeNode)equalsCall).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, new Class[]{Boolean.TYPE});
        BytecodeBlock block = new BytecodeBlock().comment("IS DISTINCT FROM").comment("left").append(generatorContext.generate(left)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNull).ifTrue((BytecodeNode)new BytecodeBlock().pop(leftType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).comment("right is not null").append(generatorContext.generate(right)).pop(rightType.getJavaType()).append((BytecodeNode)wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, new Class[]{Boolean.TYPE})).ifFalse((BytecodeNode)new BytecodeBlock().comment("right").append(generatorContext.generate(right)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNull).ifTrue((BytecodeNode)new BytecodeBlock().pop(rightType.getJavaType()).pop(leftType.getJavaType()).push(true)).ifFalse((BytecodeNode)neitherSideIsNull)))).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

