/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Scope {
    private final Optional<Scope> parent;
    private final RelationType relation;
    private final boolean approximate;
    private final boolean queryBoundary;
    private final Map<String, WithQuery> namedQueries;

    public static Scope create() {
        return Scope.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Scope(Optional<Scope> parent, RelationType relation, Map<String, WithQuery> namedQueries, boolean approximate, boolean queryBoundary) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.namedQueries = ImmutableMap.copyOf(Objects.requireNonNull(namedQueries, "namedQueries is null"));
        this.approximate = approximate;
        this.queryBoundary = queryBoundary;
    }

    public RelationType getRelationType() {
        return this.relation;
    }

    public ResolvedField resolveField(Expression expression, QualifiedName name) {
        return this.tryResolveField(expression, name).orElseThrow(() -> SemanticExceptions.throwMissingAttributeException(expression, name));
    }

    public Optional<ResolvedField> tryResolveField(Expression expression) {
        QualifiedName qualifiedName = this.asQualifiedName(expression);
        if (qualifiedName != null) {
            return this.tryResolveField(expression, qualifiedName);
        }
        return Optional.empty();
    }

    private QualifiedName asQualifiedName(Expression expression) {
        QualifiedName name = null;
        if (expression instanceof QualifiedNameReference) {
            name = ((QualifiedNameReference)expression).getName();
        } else if (expression instanceof DereferenceExpression) {
            name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
        }
        return name;
    }

    public Optional<ResolvedField> tryResolveField(Expression node, QualifiedName name) {
        return this.resolveField(node, name, true);
    }

    private Optional<ResolvedField> resolveField(Expression node, QualifiedName name, boolean local) {
        List<Field> matches = this.relation.resolveFields(name);
        if (matches.size() > 1) {
            SemanticExceptions.throwAmbiguousAttributeException(node, name);
        }
        if (matches.isEmpty()) {
            if (this.isColumnReference(name, this.relation)) {
                return Optional.empty();
            }
            Scope boundary = this;
            while (!boundary.queryBoundary) {
                if (boundary.parent.isPresent()) {
                    boundary = boundary.parent.get();
                    continue;
                }
                return Optional.empty();
            }
            if (boundary.parent.isPresent()) {
                return boundary.parent.get().resolveField(node, name, false);
            }
            return Optional.empty();
        }
        return Optional.of(this.asResolvedField((Field)Iterables.getOnlyElement(matches), local));
    }

    private ResolvedField asResolvedField(Field field, boolean local) {
        int fieldIndex = this.relation.indexOf(field);
        return new ResolvedField(this, field, fieldIndex, local);
    }

    public boolean isColumnReference(QualifiedName name) {
        Scope current = this;
        while (current != null) {
            if (this.isColumnReference(name, current.relation)) {
                return true;
            }
            current = current.parent.orElse(null);
        }
        return false;
    }

    private boolean isColumnReference(QualifiedName name, RelationType relation) {
        while (name.getPrefix().isPresent()) {
            if (relation.resolveFields(name = (QualifiedName)name.getPrefix().get()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Optional<WithQuery> getNamedQuery(String name) {
        if (this.namedQueries.containsKey(name)) {
            return Optional.of(this.namedQueries.get(name));
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getNamedQuery(name);
        }
        return Optional.empty();
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    public static final class Builder {
        private RelationType relationType = new RelationType(new Field[0]);
        private Optional<Boolean> approximate = Optional.empty();
        private boolean queryBoundary = false;
        private final Map<String, WithQuery> namedQueries = new HashMap<String, WithQuery>();
        private Optional<Scope> parent = Optional.empty();

        public Builder withRelationType(RelationType relationType) {
            this.relationType = Objects.requireNonNull(relationType, "relationType is null");
            return this;
        }

        public Builder withParent(Scope parent) {
            this.parent = Optional.of(parent);
            return this;
        }

        public Builder markQueryBoundary() {
            this.queryBoundary = true;
            return this;
        }

        public Builder withApproximate(boolean approximate) {
            this.approximate = Optional.of(approximate);
            return this;
        }

        public Builder withNamedQuery(String name, WithQuery withQuery) {
            Preconditions.checkArgument((!this.containsNamedQuery(name) ? 1 : 0) != 0, (String)"Query '%s' is already added", (Object[])new Object[]{name});
            this.namedQueries.put(name, withQuery);
            return this;
        }

        public boolean containsNamedQuery(String name) {
            return this.namedQueries.containsKey(name);
        }

        public Scope build() {
            boolean approximate = this.approximate.orElse(this.parent.map(Scope::isApproximate).orElse(false));
            return new Scope(this.parent, this.relationType, this.namedQueries, approximate, this.queryBoundary);
        }
    }
}

