/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.DenyAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalParseResult;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StackableAstVisitor;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExpressionAnalyzer {
    private final FunctionRegistry functionRegistry;
    private final TypeManager typeManager;
    private final Function<Node, StatementAnalyzer> statementAnalyzerFactory;
    private final Map<Symbol, Type> symbolTypes;
    private final IdentityHashMap<FunctionCall, Signature> resolvedFunctions = new IdentityHashMap();
    private final Set<SubqueryExpression> scalarSubqueries = Sets.newIdentityHashSet();
    private final Set<ExistsPredicate> existsSubqueries = Sets.newIdentityHashSet();
    private final IdentityHashMap<Expression, Type> expressionCoercions = new IdentityHashMap();
    private final Set<Expression> typeOnlyCoercions = Sets.newIdentityHashSet();
    private final Set<InPredicate> subqueryInPredicates = Sets.newIdentityHashSet();
    private final Set<Expression> columnReferences = Sets.newIdentityHashSet();
    private final IdentityHashMap<Expression, Type> expressionTypes = new IdentityHashMap();
    private final Session session;
    private final List<Expression> parameters;

    public ExpressionAnalyzer(FunctionRegistry functionRegistry, TypeManager typeManager, Function<Node, StatementAnalyzer> statementAnalyzerFactory, Session session, Map<Symbol, Type> symbolTypes, List<Expression> parameters) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = ImmutableMap.copyOf(Objects.requireNonNull(symbolTypes, "symbolTypes is null"));
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
    }

    public IdentityHashMap<FunctionCall, Signature> getResolvedFunctions() {
        return this.resolvedFunctions;
    }

    public IdentityHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public IdentityHashMap<Expression, Type> getExpressionCoercions() {
        return this.expressionCoercions;
    }

    public Set<Expression> getTypeOnlyCoercions() {
        return this.typeOnlyCoercions;
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Set<Expression> getColumnReferences() {
        return ImmutableSet.copyOf(this.columnReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Void>)new StackableAstVisitor.StackableAstVisitorContext(null));
    }

    public Set<SubqueryExpression> getScalarSubqueries() {
        return this.scalarSubqueries;
    }

    public Set<ExistsPredicate> getExistsSubqueries() {
        return this.existsSubqueries;
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Expression expression, List<Expression> parameters) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, types, (Iterable<Expression>)ImmutableList.of((Object)expression), parameters);
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Iterable<Expression> expressions, List<Expression> parameters) {
        return ExpressionAnalyzer.analyzeExpressionsWithSymbols(session, metadata, sqlParser, types, expressions, parameters).getExpressionTypes();
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Expression expression, List<Expression> parameters) {
        return ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, types, (Iterable<Expression>)ImmutableList.of((Object)expression), parameters);
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<Expression> expressions, List<Expression> parameters) {
        return ExpressionAnalyzer.analyzeExpressionsWithInputs(session, metadata, sqlParser, types, expressions, parameters).getExpressionTypes();
    }

    public static ExpressionAnalysis analyzeExpressionsWithSymbols(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Iterable<Expression> expressions, List<Expression> parameters) {
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, new RelationType(new Field[0]), types, expressions, parameters);
    }

    private static ExpressionAnalysis analyzeExpressionsWithInputs(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<Expression> expressions, List<Expression> parameters) {
        Field[] fields = new Field[types.size()];
        for (Map.Entry<Integer, Type> entry : types.entrySet()) {
            fields[entry.getKey().intValue()] = Field.newUnqualified(Optional.empty(), entry.getValue());
        }
        RelationType tupleDescriptor = new RelationType(fields);
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, tupleDescriptor, (Map<Symbol, Type>)ImmutableMap.of(), expressions, parameters);
    }

    private static ExpressionAnalysis analyzeExpressions(Session session, Metadata metadata, SqlParser sqlParser, RelationType tupleDescriptor, Map<Symbol, Type> types, Iterable<? extends Expression> expressions, List<Expression> parameters) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(new Analysis(null, parameters), session, metadata, sqlParser, new DenyAllAccessControl(), types, false);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(tupleDescriptor).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, Scope scope, Analysis analysis, boolean approximateQueriesEnabled, Expression expression) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, (Map<Symbol, Type>)ImmutableMap.of(), approximateQueriesEnabled);
        analyzer.analyze(expression, scope);
        IdentityHashMap<Expression, Type> expressionTypes = analyzer.getExpressionTypes();
        IdentityHashMap<Expression, Type> expressionCoercions = analyzer.getExpressionCoercions();
        Set<Expression> typeOnlyCoercions = analyzer.getTypeOnlyCoercions();
        IdentityHashMap<FunctionCall, Signature> resolvedFunctions = analyzer.getResolvedFunctions();
        analysis.addTypes(expressionTypes);
        analysis.addCoercions(expressionCoercions, typeOnlyCoercions);
        analysis.addFunctionSignatures(resolvedFunctions);
        analysis.addColumnReferences(analyzer.getColumnReferences());
        return new ExpressionAnalysis(expressionTypes, expressionCoercions, analyzer.getSubqueryInPredicates(), analyzer.getScalarSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions());
    }

    public static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, boolean experimentalSyntaxEnabled) {
        return ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, (Map<Symbol, Type>)ImmutableMap.of(), experimentalSyntaxEnabled);
    }

    public static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Map<Symbol, Type> types, boolean experimentalSyntaxEnabled) {
        return new ExpressionAnalyzer(metadata.getFunctionRegistry(), metadata.getTypeManager(), node -> new StatementAnalyzer(analysis, metadata, sqlParser, accessControl, session, experimentalSyntaxEnabled), session, types, analysis.getParameters());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, Session session, List<Expression> parameters) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata.getFunctionRegistry(), metadata.getTypeManager(), session, parameters, SemanticErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery");
    }

    public static ExpressionAnalyzer createWithoutSubqueries(FunctionRegistry functionRegistry, TypeManager typeManager, Session session, List<Expression> parameters, SemanticErrorCode errorCode, String message) {
        return new ExpressionAnalyzer(functionRegistry, typeManager, node -> {
            throw new SemanticException(errorCode, (Node)node, message, new Object[0]);
        }, session, (Map<Symbol, Type>)ImmutableMap.of(), parameters);
    }

    private class Visitor
    extends StackableAstVisitor<Type, Void> {
        private final Scope scope;

        private Visitor(Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
        }

        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = (Type)ExpressionAnalyzer.this.expressionTypes.get(node);
            if (type != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableCollectors.toImmutableList());
            RowType type = new RowType(types, Optional.empty());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            DateType type;
            if (node.getPrecision() != null) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            switch (node.getType()) {
                case DATE: {
                    type = DateType.DATE;
                    break;
                }
                case TIME: {
                    type = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIME: {
                    type = TimeType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIMESTAMP: {
                    type = TimestampType.TIMESTAMP;
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getType().getName());
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = (Type)ExpressionAnalyzer.this.symbolTypes.get(Symbol.from((Expression)node));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No type for symbol %s", (Object[])new Object[]{node.getName()});
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitQualifiedNameReference(QualifiedNameReference node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            return this.handleResolvedField((Expression)node, this.scope.resolveField((Expression)node, node.getName()));
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField) {
            ExpressionAnalyzer.this.columnReferences.add(node);
            ExpressionAnalyzer.this.expressionTypes.put(node, resolvedField.getType());
            return resolvedField.getType();
        }

        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type baseType;
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
            if (qualifiedName != null) {
                Optional<ResolvedField> resolvedField = this.scope.tryResolveField((Expression)node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField((Expression)node, resolvedField.get());
                }
                if (!this.scope.isColumnReference(qualifiedName)) {
                    SemanticExceptions.throwMissingAttributeException((Expression)node, qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getBase(), "Expression %s is not of type ROW", node.getBase());
            }
            RowType rowType = (RowType)baseType;
            Type rowFieldType = null;
            for (RowType.RowField rowField : rowType.getFields()) {
                if (!node.getFieldName().equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                rowFieldType = rowField.getType();
                break;
            }
            if (rowFieldType == null) {
                SemanticExceptions.throwMissingAttributeException((Expression)node);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, rowFieldType);
            return rowFieldType;
        }

        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            this.coerceType(context, node.getLeft(), (Type)BooleanType.BOOLEAN, "Left side of logical expression");
            this.coerceType(context, node.getRight(), (Type)BooleanType.BOOLEAN, "Right side of logical expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            OperatorType operatorType = node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM ? OperatorType.EQUAL : OperatorType.valueOf((String)node.getType().name());
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type firstType = this.process((Node)node.getFirst(), context);
            Type secondType = this.process((Node)node.getSecond(), context);
            if (!ExpressionAnalyzer.this.typeManager.getCommonSuperType(firstType, secondType).isPresent()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, firstType);
            return firstType;
        }

        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same: %s vs %s", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Objects.requireNonNull(whenClauseType, String.format("Expression types does not contain an entry for %s", whenClause));
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceToSingleType(context, (Node)whenClause, "CASE operand type does not match WHEN clause operand type: %s vs %s", node.getOperand(), whenClause.getOperand());
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Objects.requireNonNull(whenClauseType, String.format("Expression types does not contain an entry for %s", whenClause));
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands must be the same type: %s", node.getOperands());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!(type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT))) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    ExpressionAnalyzer.this.expressionTypes.put(node, type);
                    return type;
                }
                case MINUS: {
                    return this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf((String)node.getType().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type valueType = this.getVarcharType(node.getValue(), context);
            Type patternType = this.getVarcharType(node.getPattern(), context);
            this.coerceType(context, node.getValue(), valueType, "Left side of LIKE expression");
            this.coerceType(context, node.getPattern(), patternType, "Pattern for LIKE expression");
            if (node.getEscape() != null) {
                Type escapeType = this.getVarcharType(node.getEscape(), context);
                this.coerceType(context, node.getEscape(), escapeType, "Escape for LIKE expression");
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        private Type getVarcharType(Expression value, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.process((Node)value, context);
            if (!(type instanceof VarcharType)) {
                return VarcharType.VARCHAR;
            }
            return type;
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArrayConstructor(ArrayConstructor node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements must be the same type: %s", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.typeManager.getParameterizedType(ArrayParametricType.ARRAY.getName(), (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature())));
            ExpressionAnalyzer.this.expressionTypes.put(node, arrayType);
            return arrayType;
        }

        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            VarcharType type = VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitCharLiteral(CharLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            CharType type = CharType.createCharType((long)node.getValue().length());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, VarbinaryType.VARBINARY);
            return VarbinaryType.VARBINARY;
        }

        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                ExpressionAnalyzer.this.expressionTypes.put(node, IntegerType.INTEGER);
                return IntegerType.INTEGER;
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, DoubleType.DOUBLE);
            return DoubleType.DOUBLE;
        }

        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            ExpressionAnalyzer.this.expressionTypes.put(node, parseResult.getType());
            return parseResult.getType();
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (!JsonType.JSON.equals(type)) {
                try {
                    ExpressionAnalyzer.this.functionRegistry.getCoercion((Type)VarcharType.VARCHAR, type);
                }
                catch (IllegalArgumentException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimeLiteral(TimeLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Object type = DateTimeUtils.timeHasTimeZone(node.getValue()) ? TimeWithTimeZoneType.TIME_WITH_TIME_ZONE : TimeType.TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            try {
                DateTimeUtils.parseTimestampLiteral(ExpressionAnalyzer.this.session.getTimeZoneKey(), node.getValue());
            }
            catch (Exception e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
            Object type = DateTimeUtils.timestampHasTimeZone(node.getValue()) ? TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE : TimestampType.TIMESTAMP;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, UnknownType.UNKNOWN);
            return UnknownType.UNKNOWN;
        }

        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Signature function;
            if (node.getWindow().isPresent()) {
                Type type;
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = (Type)ExpressionAnalyzer.this.expressionTypes.get(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
                for (SortItem sortItem : ((Window)node.getWindow().get()).getOrderBy()) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = (Type)ExpressionAnalyzer.this.expressionTypes.get(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
                if (((Window)node.getWindow().get()).getFrame().isPresent()) {
                    Type type2;
                    WindowFrame frame = (WindowFrame)((Window)node.getWindow().get()).getFrame().get();
                    if (frame.getStart().getValue().isPresent() && !(type2 = this.process((Node)frame.getStart().getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame start value type must be INTEGER or BIGINT(actual %s)", type2);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !(type2 = this.process((Node)((FrameBound)frame.getEnd().get()).getValue().get(), context)).equals(IntegerType.INTEGER) && !type2.equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame end value type must be INTEGER or BIGINT (actual %s)", type2);
                    }
                }
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                argumentTypes.add((Object)this.process((Node)expression, context).getTypeSignature());
            }
            try {
                function = ExpressionAnalyzer.this.functionRegistry.resolveFunction(node.getName(), (List<TypeSignature>)argumentTypes.build(), this.scope.isApproximate());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                    throw new SemanticException(SemanticErrorCode.FUNCTION_NOT_FOUND, (Node)node, e.getMessage(), new Object[0]);
                }
                if (e.getErrorCode().getCode() == StandardErrorCode.AMBIGUOUS_FUNCTION_CALL.toErrorCode().getCode()) {
                    throw new SemanticException(SemanticErrorCode.AMBIGUOUS_FUNCTION_CALL, (Node)node, e.getMessage(), new Object[0]);
                }
                throw e;
            }
            for (int i = 0; i < node.getArguments().size(); ++i) {
                Expression expression = (Expression)node.getArguments().get(i);
                Type type = ExpressionAnalyzer.this.typeManager.getType(function.getArgumentTypes().get(i));
                Objects.requireNonNull(type, String.format("Type %s not found", function.getArgumentTypes().get(i)));
                if (node.isDistinct() && !type.isComparable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", type);
                }
                this.coerceType(context, expression, type, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put(node, function);
            Type type = ExpressionAnalyzer.this.typeManager.getType(function.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitAtTimeZone(AtTimeZone node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            this.process((Node)node.getTimeZone(), context);
            if (!(valueType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || valueType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || valueType.equals(TimeType.TIME) || valueType.equals(TimestampType.TIMESTAMP))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Type of value must be a time or timestamp with or without time zone (actual %s)", valueType);
            }
            Type resultType = valueType;
            if (valueType.equals(TimeType.TIME)) {
                resultType = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
            } else if (valueType.equals(TimestampType.TIMESTAMP)) {
                resultType = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, resultType);
            return resultType;
        }

        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            if (ExpressionAnalyzer.this.parameters.size() == 0) {
                throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "query takes no parameters", new Object[0]);
            }
            if (node.getPosition() >= ExpressionAnalyzer.this.parameters.size()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "invalid parameter index %s, max value is %s", node.getPosition(), ExpressionAnalyzer.this.parameters.size() - 1);
            }
            Type resultType = this.process((Node)ExpressionAnalyzer.this.parameters.get(node.getPosition()), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, resultType);
            return resultType;
        }

        protected Type visitExtract(Extract node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.process((Node)node.getExpression(), context);
            if (!this.isDateTimeType(type)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be DATE, TIME, TIMESTAMP, or INTERVAL (actual %s)", type);
            }
            Extract.Field field = node.getField();
            if (!(field != Extract.Field.TIMEZONE_HOUR && field != Extract.Field.TIMEZONE_MINUTE || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract time zone field must have a time zone (actual %s)", type);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        private boolean isDateTimeType(Type type) {
            return type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            return this.getOperator(context, (Expression)node, OperatorType.BETWEEN, node.getValue(), node.getMin(), node.getMax());
        }

        public Type visitTryExpression(TryExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.process((Node)node.getInnerExpression(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN) && !node.isTypeOnly()) {
                try {
                    ExpressionAnalyzer.this.functionRegistry.getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression valueList = node.getValueList();
            this.process((Node)valueList, context);
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                this.coerceToSingleType(context, "IN value and list items must be the same type: %s", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
            } else if (valueList instanceof SubqueryExpression) {
                this.coerceToSingleType(context, (Node)node, "value and result of subquery must be of the same type for IN expression: %s vs %s", value, valueList);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitInListExpression(InListExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.coerceToSingleType(context, "All IN list values must be the same type: %s", node.getValues());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)((Object)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node));
            Scope subqueryScope = this.createQueryBoundaryScope();
            analyzer.getAnalysis().setScope((Node)node, subqueryScope);
            Scope queryScope = (Scope)analyzer.process((Node)node.getQuery(), subqueryScope);
            if (queryScope.getRelationType().getVisibleFieldCount() != 1) {
                throw new SemanticException(SemanticErrorCode.MULTIPLE_FIELDS_FROM_SUBQUERY, (Node)node, "Multiple columns returned by subquery are not yet supported. Found %s", queryScope.getRelationType().getVisibleFieldCount());
            }
            Node previousNode = context.getPreviousNode().orElse(null);
            if (previousNode instanceof InPredicate && ((InPredicate)previousNode).getValue() != node) {
                ExpressionAnalyzer.this.subqueryInPredicates.add((InPredicate)previousNode);
            } else {
                ExpressionAnalyzer.this.scalarSubqueries.add(node);
            }
            Type type = ((Field)Iterables.getOnlyElement(queryScope.getRelationType().getVisibleFields())).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)((Object)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node));
            Scope subqueryScope = this.createQueryBoundaryScope();
            analyzer.getAnalysis().setScope((Node)node, subqueryScope);
            analyzer.process((Node)node.getSubquery(), subqueryScope);
            ExpressionAnalyzer.this.existsSubqueries.add(node);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        private Scope createQueryBoundaryScope() {
            return Scope.builder().withParent(this.scope).markQueryBoundary().build();
        }

        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            Type type = this.scope.getRelationType().getFieldByIndex(node.getFieldIndex()).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: " + node.getClass().getName(), new Object[0]);
        }

        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Void> context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, node, "not yet implemented: " + node.getClass().getName(), new Object[0]);
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Void> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            Signature operatorSignature;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorSignature = ExpressionAnalyzer.this.functionRegistry.resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build());
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s", e.getMessage());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().getCode() == StandardErrorCode.AMBIGUOUS_FUNCTION_CALL.toErrorCode().getCode()) {
                    throw new SemanticException(SemanticErrorCode.AMBIGUOUS_FUNCTION_CALL, (Node)node, e.getMessage(), new Object[0]);
                }
                throw e;
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = ExpressionAnalyzer.this.typeManager.getType(operatorSignature.getArgumentTypes().get(i));
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorSignature, i));
            }
            Type type = ExpressionAnalyzer.this.typeManager.getType(operatorSignature.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Void> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            if (!actualType.equals(expectedType)) {
                if (!ExpressionAnalyzer.this.typeManager.canCoerce(actualType, expectedType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message + " must evaluate to a %s (actual: %s)", expectedType, actualType);
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, expectedType);
                if (ExpressionAnalyzer.this.typeManager.isTypeOnlyCoercion(actualType, expectedType)) {
                    ExpressionAnalyzer.this.typeOnlyCoercions.add(expression);
                }
            }
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Void> context, Node node, String message, Expression first, Expression second) {
            Type firstType = null;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            Type secondType = null;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if (firstType == null) {
                return secondType;
            }
            if (secondType == null) {
                return firstType;
            }
            if (firstType.equals(secondType)) {
                return firstType;
            }
            if (ExpressionAnalyzer.this.typeManager.canCoerce(firstType, secondType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(first, secondType);
                if (ExpressionAnalyzer.this.typeManager.isTypeOnlyCoercion(firstType, secondType)) {
                    ExpressionAnalyzer.this.typeOnlyCoercions.add(first);
                }
                return secondType;
            }
            if (ExpressionAnalyzer.this.typeManager.canCoerce(secondType, firstType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(second, firstType);
                if (ExpressionAnalyzer.this.typeManager.isTypeOnlyCoercion(secondType, firstType)) {
                    ExpressionAnalyzer.this.typeOnlyCoercions.add(second);
                }
                return firstType;
            }
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, message, firstType, secondType);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Void> context, String message, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            for (Expression expression : expressions) {
                Optional newSuperType = ExpressionAnalyzer.this.typeManager.getCommonSuperType((Type)superType, this.process((Node)expression, context));
                if (!newSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                superType = (Type)newSuperType.get();
            }
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                if (type.equals((Object)superType)) continue;
                if (!ExpressionAnalyzer.this.typeManager.canCoerce(type, (Type)superType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, superType);
                if (!ExpressionAnalyzer.this.typeManager.isTypeOnlyCoercion(type, (Type)superType)) continue;
                ExpressionAnalyzer.this.typeOnlyCoercions.add(expression);
            }
            return superType;
        }
    }
}

