/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    private final Statement root;
    private final List<Expression> parameters;
    private String updateType;
    private final IdentityHashMap<Table, Query> namedQueries = new IdentityHashMap();
    private final IdentityHashMap<Node, Scope> scopes = new IdentityHashMap();
    private final Set<Expression> columnReferences = Sets.newIdentityHashSet();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> aggregates = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<List<Expression>>> groupByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, Expression> where = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, Expression> having = new IdentityHashMap();
    private final IdentityHashMap<Node, List<Expression>> orderByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, List<Expression>> outputExpressions = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> windowFunctions = new IdentityHashMap();
    private final IdentityHashMap<Join, Expression> joins = new IdentityHashMap();
    private final ListMultimap<Node, InPredicate> inPredicatesSubqueries = ArrayListMultimap.create();
    private final ListMultimap<Node, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final ListMultimap<Node, ExistsPredicate> existsSubqueries = ArrayListMultimap.create();
    private final IdentityHashMap<Table, TableHandle> tables = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> types = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> coercions = new IdentityHashMap();
    private final Set<Expression> typeOnlyCoercions = Sets.newIdentityHashSet();
    private final IdentityHashMap<Relation, Type[]> relationCoercions = new IdentityHashMap();
    private final IdentityHashMap<FunctionCall, Signature> functionSignature = new IdentityHashMap();
    private final IdentityHashMap<Field, ColumnHandle> columns = new IdentityHashMap();
    private final IdentityHashMap<SampledRelation, Double> sampleRatios = new IdentityHashMap();
    private Optional<QualifiedObjectName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private boolean createTableAsSelectNoOp = false;
    private Optional<Insert> insert = Optional.empty();

    public Analysis(Statement root, List<Expression> parameters) {
        Objects.requireNonNull(parameters);
        this.root = root;
        this.parameters = parameters;
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public boolean isCreateTableAsSelectNoOp() {
        return this.createTableAsSelectNoOp;
    }

    public void setCreateTableAsSelectNoOp(boolean createTableAsSelectNoOp) {
        this.createTableAsSelectNoOp = createTableAsSelectNoOp;
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(node, aggregates);
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(query);
    }

    public IdentityHashMap<Expression, Type> getTypes() {
        return new IdentityHashMap<Expression, Type>(this.types);
    }

    public Type getType(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object[])new Object[]{expression});
        return this.types.get(expression);
    }

    public Type getTypeWithCoercions(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object[])new Object[]{expression});
        if (this.coercions.containsKey(expression)) {
            return this.coercions.get(expression);
        }
        return this.types.get(expression);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(relation);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put(relation, types);
    }

    public IdentityHashMap<Expression, Type> getCoercions() {
        return this.coercions;
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(expression);
    }

    public void setGroupingSets(QuerySpecification node, List<List<Expression>> expressions) {
        this.groupByExpressions.put(node, expressions);
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(expression);
    }

    public List<List<Expression>> getGroupingSets(QuerySpecification node) {
        return this.groupByExpressions.get(node);
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put(node, expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(node);
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put(node, items);
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(node);
    }

    public void setOutputExpressions(Node node, List<Expression> expressions) {
        this.outputExpressions.put(node, expressions);
    }

    public List<Expression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(node);
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(node, expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put(node, criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(join);
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        this.inPredicatesSubqueries.putAll((Object)node, expressionAnalysis.getSubqueryInPredicates());
        this.scalarSubqueries.putAll((Object)node, expressionAnalysis.getScalarSubqueries());
        this.existsSubqueries.putAll((Object)node, expressionAnalysis.getExistsSubqueries());
    }

    public List<InPredicate> getInPredicateSubqueries(Node node) {
        if (this.inPredicatesSubqueries.containsKey((Object)node)) {
            return this.inPredicatesSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        if (this.scalarSubqueries.containsKey((Object)node)) {
            return this.scalarSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public List<ExistsPredicate> getExistsSubqueries(Node node) {
        if (this.existsSubqueries.containsKey((Object)node)) {
            return this.existsSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put(node, functions);
    }

    public Map<QuerySpecification, List<FunctionCall>> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(query);
    }

    public void addColumnReferences(Set<Expression> columnReferences) {
        this.columnReferences.addAll(columnReferences);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        if (this.scopes.containsKey(node)) {
            return Optional.of(this.scopes.get(node));
        }
        if (this.root == null) {
            return Optional.empty();
        }
        GetScopeVisitor visitor = new GetScopeVisitor(this.scopes, node);
        visitor.process((Node)this.root, null);
        return visitor.getResult();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put(node, scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(table);
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put(table, handle);
    }

    public Signature getFunctionSignature(FunctionCall function) {
        return this.functionSignature.get(function);
    }

    public void addFunctionSignatures(IdentityHashMap<FunctionCall, Signature> infos) {
        this.functionSignature.putAll(infos);
    }

    public Set<Expression> getColumnReferences() {
        return ImmutableSet.copyOf(this.columnReferences);
    }

    public void addTypes(IdentityHashMap<Expression, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put(expression, type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add(expression);
        }
    }

    public void addCoercions(IdentityHashMap<Expression, Type> coercions, Set<Expression> typeOnlyCoercions) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(query);
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedObjectName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedObjectName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = createTableProperties;
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(table);
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put(tableReference, query);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put(relation, ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(relation), (String)"Sample ratio missing for %s. Broken analysis?", (Object[])new Object[]{relation});
        return this.sampleRatios.get(relation);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;

        public Insert(TableHandle target, List<ColumnHandle> columns) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }
    }

    private static class GetScopeVisitor
    extends DefaultTraversalVisitor<Void, Scope> {
        private final IdentityHashMap<Node, Scope> scopes;
        private final Node node;
        private Scope result;

        public GetScopeVisitor(IdentityHashMap<Node, Scope> scopes, Node node) {
            this.scopes = Objects.requireNonNull(scopes, "scopes is null");
            this.node = Objects.requireNonNull(node, "node is null");
        }

        public Void process(Node current, @Nullable Scope candidate) {
            if (this.result != null) {
                return null;
            }
            if (this.scopes.containsKey(current)) {
                candidate = this.scopes.get(current);
            }
            if (this.node == current) {
                this.result = candidate;
            } else {
                super.process(current, (Object)candidate);
            }
            return null;
        }

        public Optional<Scope> getResult() {
            return Optional.ofNullable(this.result);
        }
    }
}

