/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.split.PageSinkProvider;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PageSinkManager
implements PageSinkProvider {
    private final ConcurrentMap<ConnectorId, ConnectorPageSinkProvider> pageSinkProviders = new ConcurrentHashMap<ConnectorId, ConnectorPageSinkProvider>();

    public void addConnectorPageSinkProvider(ConnectorId connectorId, ConnectorPageSinkProvider connectorPageSinkProvider) {
        this.pageSinkProviders.put(connectorId, connectorPageSinkProvider);
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, OutputTableHandle tableHandle) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.getConnectorId());
        return this.providerFor(tableHandle.getConnectorId()).createPageSink(tableHandle.getTransactionHandle(), connectorSession, tableHandle.getConnectorHandle());
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, InsertTableHandle tableHandle) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.getConnectorId());
        return this.providerFor(tableHandle.getConnectorId()).createPageSink(tableHandle.getTransactionHandle(), connectorSession, tableHandle.getConnectorHandle());
    }

    private ConnectorPageSinkProvider providerFor(ConnectorId connectorId) {
        ConnectorPageSinkProvider provider = (ConnectorPageSinkProvider)this.pageSinkProviders.get(connectorId);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page sink provider for connector '%s'", (Object[])new Object[]{connectorId});
        return provider;
    }
}

