/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.block.PagesSerde;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.RuntimeIOException;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class BinaryFileSpiller
implements Spiller {
    private final Path targetDirectory;
    private final Closer closer = Closer.create();
    private final BlockEncodingSerde blockEncodingSerde;
    private int spillsCount;
    private final ListeningExecutorService executor;

    public BinaryFileSpiller(BlockEncodingSerde blockEncodingSerde, ListeningExecutorService executor, Path spillPath) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        try {
            this.targetDirectory = Files.createTempDirectory(spillPath, "presto-spill", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create spill directory", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<?> spill(Iterator<Page> pageIterator) {
        Path spillPath = this.getPath(this.spillsCount++);
        return MoreFutures.toCompletableFuture((ListenableFuture)this.executor.submit(() -> this.writePages(pageIterator, spillPath)));
    }

    private void writePages(Iterator<Page> pageIterator, Path spillPath) {
        try (OutputStreamSliceOutput output = new OutputStreamSliceOutput((OutputStream)new BufferedOutputStream(new FileOutputStream(spillPath.toFile())));){
            PagesSerde.writePages(this.blockEncodingSerde, (SliceOutput)output, pageIterator);
        }
        catch (RuntimeIOException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to spill pages", e);
        }
    }

    @Override
    public List<Iterator<Page>> getSpills() {
        return (List)IntStream.range(0, this.spillsCount).mapToObj(i -> this.readPages(this.getPath(i))).collect(ImmutableCollectors.toImmutableList());
    }

    private Iterator<Page> readPages(Path spillPath) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(spillPath.toFile()));
            this.closer.register((Closeable)input);
            return PagesSerde.readPages(this.blockEncodingSerde, (SliceInput)new InputStreamSliceInput((InputStream)input));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to read spilled pages", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try (Stream<Path> list = Files.list(this.targetDirectory);){
            this.closer.close();
            for (Path path : list.collect(Collectors.toList())) {
                Files.delete(path);
            }
            Files.delete(this.targetDirectory);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Failed to delete directory [%s]", this.targetDirectory), (Throwable)e);
        }
    }

    private Path getPath(int spillNumber) {
        return Paths.get(this.targetDirectory.toAbsolutePath().toString(), String.format("%d.bin", spillNumber));
    }
}

