/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimeZoneNotSupportedException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class ResourceUtil {
    private ResourceUtil() {
    }

    public static Session createSessionForRequest(HttpServletRequest servletRequest, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, QueryId queryId) {
        String language;
        String timeZoneId;
        String catalog = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-Catalog"));
        String schema = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-Schema"));
        ResourceUtil.assertRequest(catalog != null || schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-User"));
        ResourceUtil.assertRequest(user != null, "User must be set", new Object[0]);
        Principal principal = servletRequest.getUserPrincipal();
        try {
            accessControl.checkCanSetUser(principal, user);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.FORBIDDEN);
        }
        Identity identity = new Identity(user, Optional.ofNullable(principal));
        Session.SessionBuilder sessionBuilder = Session.builder(sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setSource(servletRequest.getHeader("X-Presto-Source")).setCatalog(catalog).setSchema(schema).setRemoteUserAddress(servletRequest.getRemoteAddr()).setUserAgent(servletRequest.getHeader("User-Agent"));
        String transactionId = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-Transaction-Id"));
        if (transactionId != null) {
            sessionBuilder.setClientTransactionSupport();
            ResourceUtil.getTransactionId(transactionId).ifPresent(sessionBuilder::setTransactionId);
        }
        if ((timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone")) != null) {
            sessionBuilder.setTimeZoneKey(ResourceUtil.getTimeZoneKey(timeZoneId));
        }
        if ((language = servletRequest.getHeader("X-Presto-Language")) != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(language));
        }
        HashMultimap sessionPropertiesByCatalog = HashMultimap.create();
        for (String sessionHeader : ResourceUtil.splitSessionHeader(servletRequest.getHeaders("X-Presto-Session"))) {
            ResourceUtil.parseSessionHeader(sessionHeader, (Multimap<String, Map.Entry<String, String>>)sessionPropertiesByCatalog, sessionPropertyManager);
        }
        try {
            for (Map.Entry property : sessionPropertiesByCatalog.entries()) {
                String catalogName = (String)property.getKey();
                String propertyName = (String)((Map.Entry)property.getValue()).getKey();
                if (catalogName == null) {
                    accessControl.checkCanSetSystemSessionProperty(identity, propertyName);
                    continue;
                }
                accessControl.checkCanSetCatalogSessionProperty(identity, catalogName, propertyName);
            }
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        sessionBuilder.setSystemProperties(ResourceUtil.toMap(sessionPropertiesByCatalog.get(null)));
        for (Map.Entry entry : sessionPropertiesByCatalog.asMap().entrySet()) {
            if (entry.getKey() == null) continue;
            sessionBuilder.setCatalogProperties((String)entry.getKey(), ResourceUtil.toMap((Iterable)entry.getValue()));
        }
        HashMap<String, String> preparedStatements = new HashMap<String, String>();
        for (String preparedStatementsHeader : ResourceUtil.splitSessionHeader(servletRequest.getHeaders("X-Presto-Prepared-Statement"))) {
            ResourceUtil.parsePreparedStatementsHeader(preparedStatementsHeader, preparedStatements);
        }
        sessionBuilder.setPreparedStatements(preparedStatements);
        return sessionBuilder.build();
    }

    private static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
    }

    private static void parseSessionHeader(String header, Multimap<String, Map.Entry<String, String>> sessionPropertiesByCatalog, SessionPropertyManager sessionPropertyManager) {
        String name;
        String catalog;
        List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
        ResourceUtil.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session");
        String fullPropertyName = (String)nameValue.get(0);
        List nameParts = Splitter.on((char)'.').splitToList((CharSequence)fullPropertyName);
        if (nameParts.size() == 1) {
            catalog = null;
            name = (String)nameParts.get(0);
        } else if (nameParts.size() == 2) {
            catalog = (String)nameParts.get(0);
            name = (String)nameParts.get(1);
        } else {
            throw ResourceUtil.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        ResourceUtil.assertRequest(catalog == null || !catalog.isEmpty(), "Invalid %s header", "X-Presto-Session");
        ResourceUtil.assertRequest(!name.isEmpty(), "Invalid %s header", "X-Presto-Session");
        String value = (String)nameValue.get(1);
        PropertyMetadata<?> metadata = sessionPropertyManager.getSessionPropertyMetadata(fullPropertyName);
        try {
            sessionPropertyManager.decodeProperty(fullPropertyName, value, metadata.getJavaType());
        }
        catch (RuntimeException e) {
            throw ResourceUtil.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        sessionPropertiesByCatalog.put((Object)catalog, (Object)Maps.immutableEntry((Object)name, (Object)value));
    }

    private static <K, V> Map<K, V> toMap(Iterable<? extends Map.Entry<K, V>> entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, V> entry : entries) {
            builder.put(entry);
        }
        return builder.build();
    }

    public static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw ResourceUtil.badRequest(String.format(format, args));
        }
    }

    private static void parsePreparedStatementsHeader(String header, Map<String, String> preparedStatements) {
        String sqlString;
        String statementName;
        List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
        ResourceUtil.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Prepared-Statement");
        try {
            statementName = ResourceUtil.urlDecode((String)nameValue.get(0));
            sqlString = ResourceUtil.urlDecode((String)nameValue.get(1));
        }
        catch (IllegalArgumentException e) {
            throw ResourceUtil.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
        }
        SqlParser sqlParser = new SqlParser();
        try {
            sqlParser.createStatement(sqlString);
        }
        catch (ParsingException e) {
            throw ResourceUtil.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
        }
        preparedStatements.put(statementName, sqlString);
    }

    private static TimeZoneKey getTimeZoneKey(String timeZoneId) {
        try {
            return TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        }
        catch (TimeZoneNotSupportedException e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static Optional<TransactionId> getTransactionId(String transactionId) {
        if (transactionId.toUpperCase().equals("NONE")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

