/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.ValueWindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.facebook.presto.spi.function.WindowFunctionSignatures;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

@WindowFunctionSignatures(value={@WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T"}), @WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T", "bigint"}), @WindowFunctionSignature(name="lead", typeVariable="T", returnType="T", argumentTypes={"T", "bigint", "T"})})
public class LeadFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int offsetChannel;
    private final int defaultChannel;

    public LeadFunction(List<Integer> argumentChannels) {
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.size() > 1 ? argumentChannels.get(1) : -1;
        this.defaultChannel = argumentChannels.size() > 2 ? argumentChannels.get(2) : -1;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (this.offsetChannel >= 0 && this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long offset = this.offsetChannel < 0 ? 1L : this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 0", new Object[0]);
            long valuePosition = (long)currentPosition + offset;
            if (valuePosition >= 0L && valuePosition < (long)this.windowIndex.size()) {
                this.windowIndex.appendTo(this.valueChannel, Ints.checkedCast((long)valuePosition), output);
            } else if (this.defaultChannel >= 0) {
                this.windowIndex.appendTo(this.defaultChannel, currentPosition, output);
            } else {
                output.appendNull();
            }
        }
    }
}

