/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ScalarFunctionImplementation {
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final List<Boolean> nullFlags;
    private final MethodHandle methodHandle;
    private final Optional<MethodHandle> instanceFactory;
    private final boolean deterministic;

    public ScalarFunctionImplementation(boolean nullable, List<Boolean> nullableArguments, MethodHandle methodHandle, boolean deterministic) {
        this(nullable, nullableArguments, Collections.nCopies(nullableArguments.size(), false), methodHandle, Optional.empty(), deterministic);
    }

    public ScalarFunctionImplementation(boolean nullable, List<Boolean> nullableArguments, List<Boolean> nullFlags, MethodHandle methodHandle, boolean deterministic) {
        this(nullable, nullableArguments, nullFlags, methodHandle, Optional.empty(), deterministic);
    }

    public ScalarFunctionImplementation(boolean nullable, List<Boolean> nullableArguments, List<Boolean> nullFlags, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean deterministic) {
        this.nullable = nullable;
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        this.nullFlags = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullFlags, "nullFlags is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.deterministic = deterministic;
        if (instanceFactory.isPresent()) {
            TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
            Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
        }
        for (int i = 0; i < nullFlags.size(); ++i) {
            if (!nullFlags.get(i).booleanValue()) continue;
            Preconditions.checkArgument((boolean)nullableArguments.get(i), (String)"argument %s marked as @IsNull is not nullable in method: %s", (Object[])new Object[]{i, methodHandle});
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public List<Boolean> getNullFlags() {
        return this.nullFlags;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.instanceFactory;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }
}

