/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.BigIntegerAndLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.math.BigInteger;

public class BigIntegerAndLongStateSerializer
implements AccumulatorStateSerializer<BigIntegerAndLongState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(BigIntegerAndLongState state, BlockBuilder out) {
        if (state.getBigInteger() == null) {
            out.appendNull();
        } else {
            byte[] bigIntegerBytes = state.getBigInteger().toByteArray();
            Slice slice = Slices.allocate((int)(8 + bigIntegerBytes.length));
            SliceOutput output = slice.getOutput();
            output.writeLong(state.getLong());
            output.writeBytes(bigIntegerBytes);
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, BigIntegerAndLongState state) {
        if (!block.isNull(index)) {
            BasicSliceInput slice = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setLong(slice.readLong());
            byte[] bigIntegerBytes = slice.readSlice(slice.available()).getBytes();
            state.setBigInteger(new BigInteger(bigIntegerBytes));
        }
    }
}

