/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InMemoryHashAggregationBuilder
implements HashAggregationBuilder {
    private final GroupByHash groupByHash;
    private final List<Aggregator> aggregators;
    private final OperatorContext operatorContext;
    private final boolean partial;
    private boolean full;

    public InMemoryHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext) {
        this.groupByHash = GroupByHash.createGroupByHash(operatorContext.getSession(), groupByTypes, Ints.toArray(groupByChannels), hashChannel, expectedGroups);
        this.operatorContext = operatorContext;
        this.partial = step.isOutputPartial();
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        for (int i = 0; i < accumulatorFactories.size(); ++i) {
            AccumulatorFactory accumulatorFactory = accumulatorFactories.get(i);
            builder.add((Object)new Aggregator(accumulatorFactory, step));
        }
        this.aggregators = builder.build();
    }

    @Override
    public void close() {
    }

    @Override
    public void processPage(Page page) {
        if (this.aggregators.isEmpty()) {
            this.groupByHash.addPage(page);
            return;
        }
        GroupByIdBlock groupIds = this.groupByHash.getGroupIds(page);
        for (Aggregator aggregator : this.aggregators) {
            aggregator.processPage(groupIds, page);
        }
        this.updateMemory();
    }

    private void updateMemory() {
        long memorySize = this.groupByHash.getEstimatedSize();
        for (Aggregator aggregator : this.aggregators) {
            memorySize += aggregator.getEstimatedSize();
        }
        if ((memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) < 0L) {
            memorySize = 0L;
        }
        if (this.partial) {
            this.full = !this.operatorContext.trySetMemoryReservation(memorySize);
        } else {
            this.operatorContext.setMemoryReservation(memorySize);
        }
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public Iterator<Page> buildResult() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
        for (Aggregator aggregator : this.aggregators) {
            types.add(aggregator.getType());
        }
        final PageBuilder pageBuilder = new PageBuilder(types);
        return new AbstractIterator<Page>(){
            private final int groupCount;
            private int groupId;
            {
                this.groupCount = InMemoryHashAggregationBuilder.this.groupByHash.getGroupCount();
            }

            protected Page computeNext() {
                if (this.groupId >= this.groupCount) {
                    return (Page)this.endOfData();
                }
                pageBuilder.reset();
                List<Type> types = InMemoryHashAggregationBuilder.this.groupByHash.getTypes();
                while (!pageBuilder.isFull() && this.groupId < this.groupCount) {
                    InMemoryHashAggregationBuilder.this.groupByHash.appendValuesTo(this.groupId, pageBuilder, 0);
                    pageBuilder.declarePosition();
                    for (int i = 0; i < InMemoryHashAggregationBuilder.this.aggregators.size(); ++i) {
                        Aggregator aggregator = (Aggregator)InMemoryHashAggregationBuilder.this.aggregators.get(i);
                        BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                        aggregator.evaluate(this.groupId, output);
                    }
                    ++this.groupId;
                }
                return pageBuilder.build();
            }
        };
    }

    public static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AccumulatorFactory> factories, Optional<Integer> hashChannel) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        if (hashChannel.isPresent()) {
            types.add((Object)BigintType.BIGINT);
        }
        for (AccumulatorFactory factory : factories) {
            types.add((Object)new Aggregator(factory, step).getType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private final AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step) {
            if (step.isInputRaw()) {
                this.intermediateChannel = -1;
                this.aggregation = accumulatorFactory.createGroupedAccumulator();
            } else {
                Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
                this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator();
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step.isOutputPartial()) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step.isInputRaw()) {
                this.aggregation.addInput(groupIds, page);
            } else {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            }
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step.isOutputPartial()) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }
    }
}

