/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericAccumulatorFactory
implements AccumulatorFactory {
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final Optional<Integer> maskChannel;
    private final Optional<Integer> sampleWeightChannel;
    private final double confidence;
    private final List<Integer> inputChannels;

    public GenericAccumulatorFactory(AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Constructor<? extends Accumulator> accumulatorConstructor, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<Integer> inputChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
        this.stateSerializer = Objects.requireNonNull(stateSerializer, "stateSerializer is null");
        this.stateFactory = Objects.requireNonNull(stateFactory, "stateFactory is null");
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.sampleWeightChannel = Objects.requireNonNull(sampleWeightChannel, "sampleWeightChannel is null");
        this.confidence = confidence;
        this.inputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
    }

    @Override
    public List<Integer> getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Accumulator createAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, this.inputChannels, this.maskChannel, this.sampleWeightChannel, this.confidence);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, ImmutableList.of(), Optional.empty(), Optional.empty(), this.confidence);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, this.inputChannels, this.maskChannel, this.sampleWeightChannel, this.confidence);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, ImmutableList.of(), this.maskChannel, Optional.empty(), this.confidence);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

