/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.google.common.base.Throwables;
import javax.annotation.Nullable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;

public final class ApproximateUtils {
    private static final NormalDistribution NORMAL_DISTRIBUTION = new NormalDistribution();

    private ApproximateUtils() {
    }

    public static String formatApproximateResult(double mean, double error, double confidence, boolean integral) {
        double zScore;
        try {
            zScore = NORMAL_DISTRIBUTION.inverseCumulativeProbability((1.0 + confidence) / 2.0);
        }
        catch (OutOfRangeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        StringBuilder builder = new StringBuilder();
        if (integral) {
            builder.append((long)mean);
        } else {
            builder.append(mean);
        }
        builder.append(" +/- ");
        if (integral) {
            builder.append((long)Math.ceil(zScore * error));
        } else {
            builder.append(zScore * error);
        }
        return builder.toString();
    }

    public static double countError(long samples, long count) {
        if (count == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        double p = (double)samples / (double)count;
        double error = 1.0 / p * Math.sqrt((double)samples * (1.0 - p));
        return ApproximateUtils.conservativeError(error, p, samples);
    }

    public static double sumError(long samples, long count, double m2, double mean) {
        if (count == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        double p = (double)samples / (double)count;
        double variance = m2 / (double)samples;
        double error = 1.0 / p * Math.sqrt((double)samples * (variance + mean * mean * (1.0 - p)));
        return ApproximateUtils.conservativeError(error, p, samples);
    }

    private static double conservativeError(double error, double p, double samples) {
        if (p < 0.01 && samples < 100.0) {
            return Double.POSITIVE_INFINITY;
        }
        return error;
    }

    public static long computeSampleWeight(@Nullable Block masks, @Nullable Block sampleWeights, int index) {
        if (masks != null) {
            return BooleanType.BOOLEAN.getBoolean(masks, index) ? 1L : 0L;
        }
        return sampleWeights != null ? BigintType.BIGINT.getLong(sampleWeights, index) : 1L;
    }
}

