/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.VarcharType;

@AggregationFunction(value="avg", approximate=true)
public final class ApproximateAverageAggregations {
    private static final int OUTPUT_VARCHAR_SIZE = 57;

    private ApproximateAverageAggregations() {
    }

    @InputFunction
    public static void bigintInput(ApproximateAverageState state, @SqlType(value="bigint") long value, @SampleWeight long sampleWeight) {
        ApproximateAverageAggregations.doubleInput(state, value, sampleWeight);
    }

    @InputFunction
    public static void doubleInput(ApproximateAverageState state, @SqlType(value="double") double value, @SampleWeight long sampleWeight) {
        long currentCount = state.getCount();
        double currentMean = state.getMean();
        int i = 0;
        while ((long)i < sampleWeight) {
            double delta = value - currentMean;
            state.setM2(state.getM2() + delta * (value - (currentMean += delta / (double)(++currentCount))));
            ++i;
        }
        state.setCount(currentCount);
        state.setMean(currentMean);
        state.setSamples(state.getSamples() + 1L);
    }

    @CombineFunction
    public static void combine(ApproximateAverageState state, ApproximateAverageState otherState) {
        long inputCount = otherState.getCount();
        long inputSamples = otherState.getSamples();
        double inputMean = otherState.getMean();
        double inputM2 = otherState.getM2();
        long currentCount = state.getCount();
        double currentMean = state.getMean();
        double currentM2 = state.getM2();
        if (inputCount > 0L) {
            long newCount = currentCount + inputCount;
            double newMean = ((double)currentCount * currentMean + (double)inputCount * inputMean) / (double)newCount;
            double delta = inputMean - currentMean;
            double newM2 = currentM2 + inputM2 + delta * delta * (double)(currentCount * inputCount) / (double)newCount;
            state.setCount(newCount);
            state.setSamples(state.getSamples() + inputSamples);
            state.setMean(newMean);
            state.setM2(newM2);
        }
    }

    @OutputFunction(value="varchar(57)")
    public static void output(ApproximateAverageState state, double confidence, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            String result = ApproximateAverageAggregations.formatApproximateAverage(state.getSamples(), state.getMean(), state.getM2() / (double)state.getCount(), confidence);
            VarcharType.createVarcharType((int)57).writeString(out, result);
        }
    }

    private static String formatApproximateAverage(long samples, double mean, double variance, double confidence) {
        return ApproximateUtils.formatApproximateResult(mean, Math.sqrt(variance / (double)samples), confidence, false);
    }

    public static interface ApproximateAverageState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);

        public double getMean();

        public void setMean(double var1);

        public double getM2();

        public void setM2(double var1);
    }
}

