/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.CorrelationState;
import com.facebook.presto.operator.aggregation.state.CovarianceState;
import com.facebook.presto.operator.aggregation.state.RegressionState;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public final class AggregationUtils {
    private AggregationUtils() {
    }

    public static void updateVarianceState(VarianceState state, double value) {
        state.setCount(state.getCount() + 1L);
        double delta = value - state.getMean();
        state.setMean(state.getMean() + delta / (double)state.getCount());
        state.setM2(state.getM2() + delta * (value - state.getMean()));
    }

    public static void updateCovarianceState(CovarianceState state, double x, double y) {
        state.setCount(state.getCount() + 1L);
        state.setSumXY(state.getSumXY() + x * y);
        state.setSumX(state.getSumX() + x);
        state.setSumY(state.getSumY() + y);
    }

    public static double getCovarianceSample(CovarianceState state) {
        return (state.getSumXY() - state.getSumX() * state.getSumY() / (double)state.getCount()) / (double)(state.getCount() - 1L);
    }

    public static double getCovariancePopulation(CovarianceState state) {
        return (state.getSumXY() - state.getSumX() * state.getSumY() / (double)state.getCount()) / (double)state.getCount();
    }

    public static void updateCorrelationState(CorrelationState state, double x, double y) {
        AggregationUtils.updateCovarianceState(state, x, y);
        state.setSumXSquare(state.getSumXSquare() + x * x);
        state.setSumYSquare(state.getSumYSquare() + y * y);
    }

    public static double getCorrelation(CorrelationState state) {
        double dividend = (double)state.getCount() * state.getSumXY() - state.getSumX() * state.getSumY();
        dividend *= dividend;
        double divisor1 = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX();
        double divisor2 = (double)state.getCount() * state.getSumYSquare() - state.getSumY() * state.getSumY();
        return dividend / divisor1 / divisor2;
    }

    public static void updateRegressionState(RegressionState state, double x, double y) {
        AggregationUtils.updateCovarianceState(state, x, y);
        state.setSumXSquare(state.getSumXSquare() + x * x);
    }

    public static double getRegressionSlope(RegressionState state) {
        double dividend = (double)state.getCount() * state.getSumXY() - state.getSumX() * state.getSumY();
        double divisor = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX();
        return dividend / divisor;
    }

    public static double getRegressionIntercept(RegressionState state) {
        double dividend = state.getSumY() * state.getSumXSquare() - state.getSumX() * state.getSumXY();
        double divisor = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX();
        return dividend / divisor;
    }

    public static void mergeVarianceState(VarianceState state, VarianceState otherState) {
        long count = otherState.getCount();
        double mean = otherState.getMean();
        double m2 = otherState.getM2();
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + state.getCount();
        double newMean = ((double)count * mean + (double)state.getCount() * state.getMean()) / (double)newCount;
        double delta = mean - state.getMean();
        double m2Delta = m2 + delta * delta * (double)count * (double)state.getCount() / (double)newCount;
        state.setM2(state.getM2() + m2Delta);
        state.setCount(newCount);
        state.setMean(newMean);
    }

    private static void updateCovarianceState(CovarianceState state, CovarianceState otherState) {
        state.setSumX(state.getSumX() + otherState.getSumX());
        state.setSumY(state.getSumY() + otherState.getSumY());
        state.setSumXY(state.getSumXY() + otherState.getSumXY());
        state.setCount(state.getCount() + otherState.getCount());
    }

    public static void mergeCovarianceState(CovarianceState state, CovarianceState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        AggregationUtils.updateCovarianceState(state, otherState);
    }

    public static void mergeCorrelationState(CorrelationState state, CorrelationState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        AggregationUtils.updateCovarianceState(state, otherState);
        state.setSumXSquare(state.getSumXSquare() + otherState.getSumXSquare());
        state.setSumYSquare(state.getSumYSquare() + otherState.getSumYSquare());
    }

    public static void mergeRegressionState(RegressionState state, RegressionState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        AggregationUtils.updateCovarianceState(state, otherState);
        state.setSumXSquare(state.getSumXSquare() + otherState.getSumXSquare());
    }

    public static String generateAggregationName(String baseName, TypeSignature outputType, List<TypeSignature> inputTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, outputType.toString()));
        for (TypeSignature inputType : inputTypes) {
            sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, inputType.toString()));
        }
        sb.append(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, baseName.toLowerCase(Locale.ENGLISH)));
        return sb.toString();
    }

    public static Function<Integer, Block> pageBlockGetter(Page page) {
        return arg_0 -> ((Page)page).getBlock(arg_0);
    }
}

