/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.BindableAggregationFunction;
import com.facebook.presto.operator.aggregation.BlockPosition;
import com.facebook.presto.operator.aggregation.NullablePosition;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AggregationCompiler {
    private AggregationCompiler() {
    }

    @VisibleForTesting
    public static BindableAggregationFunction generateAggregationBindableFunction(Class<?> clazz) {
        List<BindableAggregationFunction> aggregations = AggregationCompiler.generateBindableAggregationFunctions(clazz);
        Preconditions.checkArgument((aggregations.size() == 1 ? 1 : 0) != 0, (Object)"More than one aggregation function found");
        return aggregations.get(0);
    }

    public static BindableAggregationFunction generateAggregationBindableFunction(Class<?> clazz, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        for (BindableAggregationFunction aggregation : AggregationCompiler.generateBindableAggregationFunctions(clazz)) {
            if (!aggregation.getSignature().getReturnType().equals((Object)returnType) || !aggregation.getSignature().getArgumentTypes().equals(argumentTypes)) continue;
            return aggregation;
        }
        throw new IllegalArgumentException(String.format("No method with return type %s and arguments %s", returnType, argumentTypes));
    }

    public static List<BindableAggregationFunction> generateBindableAggregationFunctions(Class<?> aggregationDefinition) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        DynamicClassLoader classLoader = new DynamicClassLoader(aggregationDefinition.getClassLoader());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> stateClass : AggregationCompiler.getStateClasses(aggregationDefinition)) {
            AccumulatorStateSerializer<?> stateSerializer = new StateCompiler().generateStateSerializer(stateClass, classLoader);
            for (Method outputFunction : AggregationCompiler.getOutputFunctions(aggregationDefinition, stateClass)) {
                for (Method inputFunction : AggregationCompiler.getInputFunctions(aggregationDefinition, stateClass)) {
                    for (String name : AggregationCompiler.getNames(outputFunction, aggregationAnnotation)) {
                        List<TypeSignature> inputTypes = AggregationCompiler.getInputTypesSignatures(inputFunction);
                        TypeSignature outputType = TypeSignature.parseTypeSignature((String)outputFunction.getAnnotation(OutputFunction.class).value());
                        builder.add((Object)new BindableAggregationFunction(new Signature(name, aggregationAnnotation.approximate() ? FunctionKind.APPROXIMATE_AGGREGATE : FunctionKind.AGGREGATE, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), outputType, inputTypes, false), AggregationCompiler.getDescription(aggregationDefinition, outputFunction), aggregationAnnotation.approximate(), aggregationAnnotation.decomposable(), aggregationDefinition, stateClass, inputFunction, outputFunction));
                    }
                }
            }
        }
        return builder.build();
    }

    public static boolean isParameterNullable(Annotation[] annotations) {
        return Arrays.asList(annotations).stream().anyMatch(annotation -> annotation instanceof NullablePosition);
    }

    public static boolean isParameterBlock(Annotation[] annotations) {
        return Arrays.asList(annotations).stream().anyMatch(annotation -> annotation instanceof BlockPosition);
    }

    private static List<String> getNames(@Nullable Method outputFunction, AggregationFunction aggregationAnnotation) {
        ImmutableList defaultNames = ImmutableList.builder().add((Object)aggregationAnnotation.value()).addAll(Arrays.asList(aggregationAnnotation.alias())).build();
        if (outputFunction == null) {
            return defaultNames;
        }
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation == null) {
            return defaultNames;
        }
        return ImmutableList.builder().add((Object)annotation.value()).addAll(Arrays.asList(annotation.alias())).build();
    }

    public static Method getCombineFunction(Class<?> clazz, Class<?> stateClass) {
        for (Method method : AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, CombineFunction.class)) {
            if (method.getParameterTypes()[0] != stateClass) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("No method with @CombineFunction annotation found in class %s for %s", clazz.toGenericString(), stateClass.toGenericString()));
    }

    private static List<Method> getOutputFunctions(Class<?> clazz, Class<?> stateClass) {
        List methods = (List)AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, OutputFunction.class).stream().filter(method -> method.getParameterTypes()[0] == stateClass).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no output functions");
        return methods;
    }

    private static List<Method> getInputFunctions(Class<?> clazz, Class<?> stateClass) {
        List inputFunctions = (List)AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class).stream().filter(method -> method.getParameterTypes()[0] == stateClass).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((!inputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no input functions");
        return inputFunctions;
    }

    private static List<TypeSignature> getInputTypesSignatures(Method inputFunction) {
        Annotation[][] parameterAnnotations;
        ImmutableList.Builder builder = ImmutableList.builder();
        Set<String> literalParameters = AggregationCompiler.getLiteralParameter(inputFunction);
        Annotation[][] annotationArray = parameterAnnotations = inputFunction.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!(annotation instanceof SqlType)) continue;
                String typeName = ((SqlType)annotation).value();
                builder.add((Object)TypeSignature.parseTypeSignature((String)typeName, literalParameters));
            }
        }
        return builder.build();
    }

    private static Set<Class<?>> getStateClasses(Class<?> clazz) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method inputFunction : AggregationCompiler.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class)) {
            Preconditions.checkArgument((inputFunction.getParameterTypes().length > 0 ? 1 : 0) != 0, (Object)"Input function has no parameters");
            Class<?> stateClass = inputFunction.getParameterTypes()[0];
            Preconditions.checkArgument((boolean)AccumulatorState.class.isAssignableFrom(stateClass), (Object)"stateClass is not a subclass of AccumulatorState");
            builder.add(stateClass);
        }
        ImmutableSet stateClasses = builder.build();
        Preconditions.checkArgument((!stateClasses.isEmpty() ? 1 : 0) != 0, (Object)"No input functions found");
        return stateClasses;
    }

    private static String getDescription(AnnotatedElement base, AnnotatedElement override) {
        Description description = override.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        description = base.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }

    private static Set<String> getLiteralParameter(Method inputFunction) {
        Annotation[] literalParameters;
        ImmutableSet.Builder literalParametersBuilder = ImmutableSet.builder();
        for (Annotation annotation : literalParameters = inputFunction.getAnnotations()) {
            if (!(annotation instanceof LiteralParameters)) continue;
            for (String literal : ((LiteralParameters)annotation).value()) {
                literalParametersBuilder.add((Object)literal);
            }
        }
        return literalParametersBuilder.build();
    }

    private static List<Method> findPublicStaticMethodsWithAnnotation(Class<?> clazz, Class<?> annotationClass) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Method method : clazz.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotationClass.isInstance(annotation)) continue;
                Preconditions.checkArgument((Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) ? 1 : 0) != 0, (String)"%s annotated with %s must be static and public", (Object[])new Object[]{method.getName(), annotationClass.getSimpleName()});
                methods.add((Object)method);
            }
        }
        return methods.build();
    }
}

