/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class AccumulatorCompiler {
    public GenericAccumulatorFactoryBinder generateAccumulatorFactoryBinder(AggregationMetadata metadata, DynamicClassLoader classLoader) {
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new GenericAccumulatorFactoryBinder(metadata.getStateSerializer(), metadata.getStateFactory(), accumulatorClass, groupedAccumulatorClass, metadata.isApproximate());
    }

    private static <T> Class<? extends T> generateAccumulatorClass(Class<T> accumulatorInterface, AggregationMetadata metadata, DynamicClassLoader classLoader) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        boolean approximate = metadata.isApproximate();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)(metadata.getName() + accumulatorInterface.getSimpleName())), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(accumulatorInterface)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        AccumulatorStateSerializer<?> stateSerializer = metadata.getStateSerializer();
        AccumulatorStateFactory<?> stateFactory = metadata.getStateFactory();
        FieldDefinition stateSerializerField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateSerializer", AccumulatorStateSerializer.class);
        FieldDefinition stateFactoryField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateFactory", AccumulatorStateFactory.class);
        FieldDefinition inputChannelsField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "inputChannels", ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        FieldDefinition maskChannelField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "maskChannel", ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        FieldDefinition sampleWeightChannelField = null;
        FieldDefinition confidenceField = null;
        if (approximate) {
            sampleWeightChannelField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "sampleWeightChannel", ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
            confidenceField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "confidence", Double.TYPE);
        }
        FieldDefinition stateField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "state", grouped ? stateFactory.getGroupedStateClass() : stateFactory.getSingleStateClass());
        AccumulatorCompiler.generateConstructor(definition, stateSerializerField, stateFactoryField, inputChannelsField, maskChannelField, sampleWeightChannelField, confidenceField, stateField, grouped);
        AccumulatorCompiler.generateAddInput(definition, stateField, inputChannelsField, maskChannelField, sampleWeightChannelField, metadata.getInputMetadata(), metadata.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateField);
        AccumulatorCompiler.generateGetIntermediateType(definition, callSiteBinder, stateSerializer.getSerializedType());
        AccumulatorCompiler.generateGetFinalType(definition, callSiteBinder, metadata.getOutputType());
        AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateField, stateSerializerField, stateFactoryField, metadata.getCombineFunction(), stateFactory.getSingleStateClass(), callSiteBinder, grouped);
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateSerializerField, stateField);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, stateSerializerField, stateField);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, confidenceField, stateField, metadata.getOutputFunction(), metadata.isApproximate(), callSiteBinder);
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, confidenceField, stateField, metadata.getOutputFunction(), metadata.isApproximate(), callSiteBinder);
        }
        return CompilerUtils.defineClass((ClassDefinition)definition, accumulatorInterface, callSiteBinder.getBindings(), (ClassLoader)classLoader);
    }

    private static MethodDefinition generateGetIntermediateType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getIntermediateType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static MethodDefinition generateGetFinalType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getFinalType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, FieldDefinition stateField) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        BytecodeExpression state = method.getThis().getField(stateField);
        method.getBody().append((BytecodeNode)state.invoke("getEstimatedSize", Long.TYPE, new BytecodeExpression[0]).ret());
    }

    private static void generateAddInput(ClassDefinition definition, FieldDefinition stateField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        Parameter page = Parameter.arg((String)"page", Page.class);
        parameters.add((Object)page);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addInput", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        ArrayList<Variable> parameterVariables = new ArrayList<Variable>();
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            parameterVariables.add(scope.declareVariable(Block.class, "block" + i));
        }
        Variable masksBlock = scope.declareVariable(Block.class, "masksBlock");
        Variable sampleWeightsBlock = null;
        if (sampleWeightChannelField != null) {
            sampleWeightsBlock = scope.declareVariable(Block.class, "sampleWeightsBlock");
        }
        body.comment("masksBlock = maskChannel.map(page.blockGetter()).orElse(null);").append((BytecodeNode)thisVariable.getField(maskChannelField)).append((BytecodeNode)page).invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, (Class[])new Class[]{Integer.class, Block.class}), new ParameterizedType[]{ParameterizedType.type(Page.class)}).invokeVirtual(Optional.class, "map", Optional.class, new Class[]{Function.class}).pushNull().invokeVirtual(Optional.class, "orElse", Object.class, new Class[]{Object.class}).checkCast(Block.class).putVariable(masksBlock);
        if (sampleWeightChannelField != null) {
            body.comment("sampleWeightsBlock = sampleWeightChannel.map(page.blockGetter()).get();").append((BytecodeNode)thisVariable.getField(sampleWeightChannelField)).append((BytecodeNode)page).invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, (Class[])new Class[]{Integer.class, Block.class}), new ParameterizedType[]{ParameterizedType.type(Page.class)}).invokeVirtual(Optional.class, "map", Optional.class, new Class[]{Function.class}).invokeVirtual(Optional.class, "get", Object.class, new Class[0]).checkCast(Block.class).putVariable(sampleWeightsBlock);
        }
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            body.comment("%s = page.getBlock(inputChannels.get(%d));", new Object[]{((Variable)parameterVariables.get(i)).getName(), i}).append((BytecodeNode)page).append((BytecodeNode)thisVariable.getField(inputChannelsField)).push(i).invokeInterface(List.class, "get", Object.class, new Class[]{Integer.TYPE}).checkCast(Integer.class).invokeVirtual(Integer.class, "intValue", Integer.TYPE, new Class[0]).invokeVirtual(Page.class, "getBlock", Block.class, new Class[]{Integer.TYPE}).putVariable((Variable)parameterVariables.get(i));
        }
        BytecodeBlock block = AccumulatorCompiler.generateInputForLoop(stateField, parameterMetadatas, inputFunction, scope, parameterVariables, masksBlock, sampleWeightsBlock, callSiteBinder, grouped);
        body.append((BytecodeNode)block);
        body.ret();
    }

    private static BytecodeBlock generateInputForLoop(FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, Scope scope, List<Variable> parameterVariables, Variable masksBlock, @Nullable Variable sampleWeightsBlock, CallSiteBinder callSiteBinder, boolean grouped) {
        Variable page = scope.getVariable("page");
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        Variable sampleWeightVariable = null;
        if (sampleWeightsBlock != null) {
            sampleWeightVariable = scope.declareVariable(Long.TYPE, "sampleWeight");
        }
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)page).invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable).initializeVariable(positionVariable);
        if (sampleWeightVariable != null) {
            block.initializeVariable(sampleWeightVariable);
        }
        Object loopBody = AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, sampleWeightVariable, parameterVariables, parameterMetadatas, inputFunction, callSiteBinder, grouped);
        ArrayList<Boolean> nullable = new ArrayList<Boolean>();
        for (AggregationMetadata.ParameterMetadata metadata : parameterMetadatas) {
            switch (metadata.getParameterType()) {
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: {
                    nullable.add(false);
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    nullable.add(true);
                    break;
                }
            }
        }
        Preconditions.checkState((nullable.size() == parameterVariables.size() ? 1 : 0) != 0, (Object)"Number of parameters does not match");
        for (int i = 0; i < parameterVariables.size(); ++i) {
            if (((Boolean)nullable.get(i)).booleanValue()) continue;
            Variable variableDefinition = parameterVariables.get(i);
            loopBody = new IfStatement("if(!%s.isNull(position))", new Object[]{variableDefinition.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(variableDefinition).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        }
        loopBody = sampleWeightVariable != null ? AccumulatorCompiler.generateComputeSampleWeightAndCheckGreaterThanZero((BytecodeNode)loopBody, sampleWeightVariable, masksBlock, sampleWeightsBlock, positionVariable) : new IfStatement("if(testMask(%s, position))", new Object[]{masksBlock.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(masksBlock).getVariable(positionVariable).invokeStatic(CompilerOperations.class, "testMask", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE})).ifTrue((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)new BytecodeBlock().putVariable(positionVariable, 0)).condition((BytecodeNode)new BytecodeBlock().getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)loopBody));
        return block;
    }

    private static BytecodeNode generateComputeSampleWeightAndCheckGreaterThanZero(BytecodeNode body, Variable sampleWeight, Variable masks, Variable sampleWeights, Variable position) {
        BytecodeBlock block = new BytecodeBlock().comment("sampleWeight = computeSampleWeight(masks, sampleWeights, position);").getVariable(masks).getVariable(sampleWeights).getVariable(position).invokeStatic(ApproximateUtils.class, "computeSampleWeight", Long.TYPE, new Class[]{Block.class, Block.class, Integer.TYPE}).putVariable(sampleWeight);
        block.append((BytecodeNode)new IfStatement("if(sampleWeight > 0)", new Object[0]).condition((BytecodeNode)new BytecodeBlock().getVariable(sampleWeight).invokeStatic(CompilerOperations.class, "longGreaterThanZero", Boolean.TYPE, new Class[]{Long.TYPE})).ifTrue(body).ifFalse((BytecodeNode)OpCode.NOP));
        return block;
    }

    private static BytecodeBlock generateInvokeInputFunction(Scope scope, FieldDefinition stateField, Variable position, @Nullable Variable sampleWeight, List<Variable> parameterVariables, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        BytecodeBlock block = new BytecodeBlock();
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(scope, stateField, block);
        }
        block.comment("Call input function with unpacked Block arguments");
        Class<?>[] parameters = inputFunction.type().parameterArray();
        int inputChannel = 0;
        block7: for (int i = 0; i < parameters.length; ++i) {
            AggregationMetadata.ParameterMetadata parameterMetadata = parameterMetadatas.get(i);
            switch (parameterMetadata.getParameterType()) {
                case STATE: {
                    block.append((BytecodeNode)scope.getThis().getField(stateField));
                    continue block7;
                }
                case BLOCK_INDEX: {
                    block.getVariable(position);
                    continue block7;
                }
                case SAMPLE_WEIGHT: {
                    Objects.requireNonNull(sampleWeight, "sampleWeight is null");
                    block.getVariable(sampleWeight);
                    continue block7;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    block.getVariable(parameterVariables.get(inputChannel));
                    ++inputChannel;
                    continue block7;
                }
                case INPUT_CHANNEL: {
                    BytecodeBlock getBlockBytecode = new BytecodeBlock().getVariable(parameterVariables.get(inputChannel));
                    AccumulatorCompiler.pushStackType(scope, block, parameterMetadata.getSqlType(), getBlockBytecode, parameters[i], callSiteBinder);
                    ++inputChannel;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + (Object)((Object)parameterMetadata.getParameterType()));
                }
            }
        }
        block.append(BytecodeUtils.invoke(callSiteBinder.bind(inputFunction), "input"));
        return block;
    }

    private static void pushStackType(Scope scope, BytecodeBlock block, Type sqlType, BytecodeBlock getBlockBytecode, Class<?> parameter, CallSiteBinder callSiteBinder) {
        Variable position = scope.getVariable("position");
        if (parameter == Long.TYPE) {
            block.comment("%s.getLong(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getLong", Long.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Double.TYPE) {
            block.comment("%s.getDouble(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getDouble", Double.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Boolean.TYPE) {
            block.comment("%s.getBoolean(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getBoolean", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Slice.class) {
            block.comment("%s.getSlice(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getSlice", Slice.class, new Class[]{Block.class, Integer.TYPE});
        } else {
            block.comment("%s.getObject(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getObject", Object.class, new Class[]{Block.class, Integer.TYPE});
        }
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, FieldDefinition stateField, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, MethodHandle combineFunction, Class<?> singleStateClass, CallSiteBinder callSiteBinder, boolean grouped) {
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable block = scope.getVariable("block");
        Variable scratchState = scope.declareVariable(singleStateClass, "scratchState");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.comment("scratchState = stateFactory.createSingleState();").append((BytecodeNode)thisVariable.getField(stateFactoryField)).invokeInterface(AccumulatorStateFactory.class, "createSingleState", Object.class, new Class[0]).checkCast(scratchState.getType()).putVariable(scratchState);
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        BytecodeBlock loopBody = new BytecodeBlock();
        if (grouped) {
            Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
            loopBody.append((BytecodeNode)thisVariable.getField(stateField).invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
        }
        loopBody.append((BytecodeNode)thisVariable.getField(stateSerializerField).invoke("deserialize", Void.TYPE, new BytecodeExpression[]{block, position, scratchState.cast(Object.class)}));
        loopBody.comment("combine(state, scratchState)").append((BytecodeNode)thisVariable.getField(stateField)).append((BytecodeNode)scratchState).append(BytecodeUtils.invoke(callSiteBinder.bind(combineFunction), "combine"));
        if (grouped) {
            IfStatement ifStatement = new IfStatement("if (!groupIdsBlock.isNull(position))", new Object[0]).condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)scope.getVariable("groupIdsBlock").invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)loopBody);
            loopBody = new BytecodeBlock().append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, position, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIdsBlock(Scope scope, FieldDefinition stateField, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        Variable position = scope.getVariable("position");
        BytecodeExpression state = scope.getThis().getField(stateField);
        block.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
    }

    private static void generateEnsureCapacity(Scope scope, FieldDefinition stateField, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        BytecodeExpression state = scope.getThis().getField(stateField);
        block.append((BytecodeNode)state.invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupCount", Long.TYPE, new BytecodeExpression[0])}));
    }

    private static MethodDefinition declareAddIntermediate(ClassDefinition definition, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)Parameter.arg((String)"block", Block.class));
        return definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
    }

    private static BytecodeBlock generateBlockNonNullPositionForLoop(Scope scope, Variable positionVariable, BytecodeBlock loopBody) {
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable blockVariable = scope.getVariable("block");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)blockVariable).invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement ifStatement = new IfStatement("if(!block.isNull(position))", new Object[0]).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockVariable).append((BytecodeNode)positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positionVariable).append((BytecodeNode)rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)ifStatement));
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        BytecodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        method.getBody().append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)})).append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(Object.class), out})).ret();
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        Variable thisVariable = method.getThis();
        BytecodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        BytecodeExpression state = thisVariable.getField(stateField);
        method.getBody().append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(Object.class), out})).ret();
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, FieldDefinition confidenceField, FieldDefinition stateField, MethodHandle outputFunction, boolean approximate, CallSiteBinder callSiteBinder) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)}));
        body.comment("output(state, out)");
        body.append((BytecodeNode)state);
        if (approximate) {
            Objects.requireNonNull(confidenceField, "confidenceField is null");
            body.append((BytecodeNode)thisVariable.getField(confidenceField));
        }
        body.append((BytecodeNode)out);
        body.append(BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, FieldDefinition confidenceField, FieldDefinition stateField, MethodHandle outputFunction, boolean approximate, CallSiteBinder callSiteBinder) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        body.comment("output(state, out)");
        body.append((BytecodeNode)state);
        if (approximate) {
            Objects.requireNonNull(confidenceField, "confidenceField is null");
            body.append((BytecodeNode)thisVariable.getField(confidenceField));
        }
        body.append((BytecodeNode)out);
        body.append(BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateConstructor(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, @Nullable FieldDefinition confidenceField, FieldDefinition stateField, boolean grouped) {
        Parameter stateSerializer = Parameter.arg((String)"stateSerializer", AccumulatorStateSerializer.class);
        Parameter stateFactory = Parameter.arg((String)"stateFactory", AccumulatorStateFactory.class);
        Parameter inputChannels = Parameter.arg((String)"inputChannels", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        Parameter maskChannel = Parameter.arg((String)"maskChannel", (ParameterizedType)ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        Parameter sampleWeightChannel = Parameter.arg((String)"sampleWeightChannel", (ParameterizedType)ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        Parameter confidence = Parameter.arg((String)"confidence", Double.TYPE);
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{stateSerializer, stateFactory, inputChannels, maskChannel, sampleWeightChannel, confidence});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(stateSerializerField, AccumulatorCompiler.generateRequireNotNull((Variable)stateSerializer)));
        body.append((BytecodeNode)thisVariable.setField(stateFactoryField, AccumulatorCompiler.generateRequireNotNull((Variable)stateFactory)));
        body.append((BytecodeNode)thisVariable.setField(inputChannelsField, AccumulatorCompiler.generateRequireNotNull((Variable)inputChannels)));
        body.append((BytecodeNode)thisVariable.setField(maskChannelField, AccumulatorCompiler.generateRequireNotNull((Variable)maskChannel)));
        if (sampleWeightChannelField != null) {
            body.append((BytecodeNode)thisVariable.setField(sampleWeightChannelField, AccumulatorCompiler.generateRequireNotNull((Variable)sampleWeightChannel)));
        }
        String createState = grouped ? "createGroupedState" : "createSingleState";
        if (confidenceField != null) {
            body.append((BytecodeNode)thisVariable.setField(confidenceField, (BytecodeExpression)confidence));
        }
        body.append((BytecodeNode)thisVariable.setField(stateField, stateFactory.invoke(createState, Object.class, new BytecodeExpression[0]).cast(stateField.getType())));
        body.ret();
    }

    private static BytecodeExpression generateRequireNotNull(Variable variable) {
        return BytecodeExpressions.invokeStatic(Objects.class, (String)"requireNonNull", Object.class, (BytecodeExpression[])new BytecodeExpression[]{variable.cast(Object.class), BytecodeExpressions.constantString((String)(variable.getName() + " is null"))}).cast(variable.getType());
    }
}

