/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunctionVerifier;
import com.facebook.presto.spi.block.Block;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class StandardJoinFilterFunctionVerifier
implements JoinFilterFunctionVerifier {
    private static final Block[] EMPTY_BLOCK_ARRAY = new Block[0];
    private final JoinFilterFunction filterFunction;
    private final List<Block[]> pages;

    public StandardJoinFilterFunctionVerifier(JoinFilterFunction filterFunction, List<List<Block>> channels) {
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null");
        Objects.requireNonNull(channels, "channels can not be null");
        ImmutableList.Builder pagesBuilder = ImmutableList.builder();
        if (!channels.isEmpty()) {
            int pagesCount = channels.get(0).size();
            for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
                Block[] blocks = new Block[channels.size()];
                for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
                    blocks[channelIndex] = channels.get(channelIndex).get(pageIndex);
                }
                pagesBuilder.add((Object)blocks);
            }
        }
        this.pages = pagesBuilder.build();
    }

    @Override
    public boolean applyFilterFunction(int leftBlockIndex, int leftPosition, int rightPosition, Block[] allRightBlocks) {
        return this.filterFunction.filter(leftPosition, this.getLeftBlocks(leftBlockIndex), rightPosition, allRightBlocks);
    }

    private Block[] getLeftBlocks(int leftBlockIndex) {
        if (this.pages.isEmpty()) {
            return EMPTY_BLOCK_ARRAY;
        }
        return this.pages.get(leftBlockIndex);
    }
}

