/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OuterLookupSource;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public final class SettableLookupSourceSupplier
implements LookupSourceSupplier {
    private final List<Type> types;
    private final boolean outer;
    private final SettableFuture<LookupSource> lookupSourceFuture = SettableFuture.create();
    private final Map<Symbol, Integer> layout;
    @GuardedBy(value="this")
    private State state = State.NOT_SET;
    @GuardedBy(value="this")
    private Runnable onDestroy;

    public SettableLookupSourceSupplier(List<Type> types, Map<Symbol, Integer> layout, boolean outer) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.layout = ImmutableMap.copyOf(Objects.requireNonNull(layout, "layout is null"));
        this.outer = outer;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Map<Symbol, Integer> getLayout() {
        return this.layout;
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource() {
        return this.lookupSourceFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupSource(LookupSource lookupSource, OperatorContext operatorContext) {
        if (this.outer) {
            lookupSource = new OuterLookupSource(lookupSource);
        }
        SettableLookupSourceSupplier settableLookupSourceSupplier = this;
        synchronized (settableLookupSourceSupplier) {
            Objects.requireNonNull(lookupSource, "lookupSource is null");
            Objects.requireNonNull(operatorContext, "operatorContext is null");
            if (this.state == State.DESTROYED) {
                return;
            }
            Preconditions.checkState((this.state == State.NOT_SET ? 1 : 0) != 0, (Object)"Lookup source already set");
            this.state = State.SET;
            long lookupSourceSizeInBytes = lookupSource.getInMemorySizeInBytes();
            operatorContext.transferMemoryToTaskContext(lookupSourceSizeInBytes);
            TaskContext taskContext = operatorContext.getDriverContext().getPipelineContext().getTaskContext();
            this.onDestroy = () -> taskContext.freeMemory(lookupSourceSizeInBytes);
        }
        this.lookupSourceFuture.set((Object)lookupSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Runnable onDestroy;
        SettableLookupSourceSupplier settableLookupSourceSupplier = this;
        synchronized (settableLookupSourceSupplier) {
            if (this.state == State.DESTROYED) {
                return;
            }
            this.state = State.DESTROYED;
            onDestroy = this.onDestroy;
        }
        if (onDestroy != null) {
            onDestroy.run();
        }
    }

    private static enum State {
        NOT_SET,
        SET,
        DESTROYED;

    }
}

