/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.PartitionedLookupSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;

public final class PartitionedLookupSourceSupplier
implements LookupSourceSupplier,
Closeable {
    private final List<Type> types;
    private final Map<Symbol, Integer> layout;
    private final List<Type> hashChannelTypes;
    private final SettableFuture<LookupSource> lookupSourceFuture = SettableFuture.create();
    private final LookupSource[] partitions;
    private final boolean outer;
    private final CompletableFuture<?> destroyed = new CompletableFuture();
    @GuardedBy(value="this")
    private int partitionsSet;

    public PartitionedLookupSourceSupplier(List<Type> types, List<Integer> hashChannels, int partitionCount, Map<Symbol, Integer> layout, boolean outer) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.layout = ImmutableMap.copyOf(layout);
        this.partitions = new LookupSource[partitionCount];
        this.outer = outer;
        this.hashChannelTypes = (List)hashChannels.stream().map(types::get).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Map<Symbol, Integer> getLayout() {
        return this.layout;
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource() {
        return this.lookupSourceFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupSource(int partitionIndex, LookupSource lookupSource) {
        PartitionedLookupSource partitionedLookupSource = null;
        PartitionedLookupSourceSupplier partitionedLookupSourceSupplier = this;
        synchronized (partitionedLookupSourceSupplier) {
            Objects.requireNonNull(lookupSource, "lookupSource is null");
            if (this.destroyed.isDone()) {
                return;
            }
            Preconditions.checkState((this.partitions[partitionIndex] == null ? 1 : 0) != 0, (Object)"Partition already set");
            this.partitions[partitionIndex] = lookupSource;
            ++this.partitionsSet;
            if (this.partitionsSet == this.partitions.length) {
                partitionedLookupSource = new PartitionedLookupSource((List<? extends LookupSource>)ImmutableList.copyOf((Object[])this.partitions), this.hashChannelTypes, this.outer);
            }
        }
        if (partitionedLookupSource != null) {
            this.lookupSourceFuture.set(partitionedLookupSource);
        }
    }

    @Override
    public void destroy() {
        this.destroyed.complete(null);
    }

    public CompletableFuture<?> isDestroyed() {
        return MoreFutures.unmodifiableFuture(this.destroyed);
    }

    @Override
    public void close() {
    }
}

