/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class PartitionedLookupSource
implements LookupSource {
    private final LookupSource[] lookupSources;
    private final LocalPartitionGenerator partitionGenerator;
    private final int partitionMask;
    private final int shiftSize;
    @GuardedBy(value="this")
    private final boolean[][] visitedPositions;

    public PartitionedLookupSource(List<? extends LookupSource> lookupSources, List<Type> hashChannelTypes, boolean outer) {
        this.lookupSources = lookupSources.toArray(new LookupSource[lookupSources.size()]);
        int[] hashChannels = new int[hashChannelTypes.size()];
        for (int i = 0; i < hashChannels.length; ++i) {
            hashChannels[i] = i;
        }
        this.partitionGenerator = new LocalPartitionGenerator(new InterpretedHashGenerator(hashChannelTypes, hashChannels), lookupSources.size());
        this.partitionMask = lookupSources.size() - 1;
        this.shiftSize = Integer.numberOfTrailingZeros(lookupSources.size()) + 1;
        if (outer) {
            this.visitedPositions = new boolean[lookupSources.size()][];
            for (int source = 0; source < this.lookupSources.length; ++source) {
                this.visitedPositions[source] = new boolean[this.lookupSources[source].getJoinPositionCount()];
            }
        } else {
            this.visitedPositions = null;
        }
    }

    @Override
    public int getChannelCount() {
        return this.lookupSources[0].getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        throw new UnsupportedOperationException("Parallel hash can not be used in a RIGHT or FULL outer join");
    }

    @Override
    public long getInMemorySizeInBytes() {
        return Arrays.stream(this.lookupSources).mapToLong(LookupSource::getInMemorySizeInBytes).sum();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        return this.getJoinPosition(position, hashChannelsPage, allChannelsPage, this.partitionGenerator.getRawHash(position, hashChannelsPage));
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int partition = this.partitionGenerator.getPartition(rawHash);
        LookupSource lookupSource = this.lookupSources[partition];
        long joinPosition = lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage, rawHash);
        if (joinPosition < 0L) {
            return joinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Ints.checkedCast((long)joinPosition));
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        long joinPosition;
        int partition = this.decodePartition(currentJoinPosition);
        LookupSource lookupSource = this.lookupSources[partition];
        long nextJoinPosition = lookupSource.getNextJoinPosition(joinPosition = (long)this.decodeJoinPosition(currentJoinPosition), probePosition, allProbeChannelsPage);
        if (nextJoinPosition < 0L) {
            return nextJoinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Ints.checkedCast((long)nextJoinPosition));
    }

    @Override
    public void appendTo(long partitionedJoinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        int partition = this.decodePartition(partitionedJoinPosition);
        int joinPosition = this.decodeJoinPosition(partitionedJoinPosition);
        this.lookupSources[partition].appendTo(joinPosition, pageBuilder, outputChannelOffset);
        if (this.visitedPositions != null) {
            this.visitedPositions[partition][joinPosition] = true;
        }
    }

    @Override
    public LookupSource.OuterPositionIterator getOuterPositionIterator() {
        return new PartitionedLookupOuterPositionIterator();
    }

    @Override
    public void close() {
    }

    private int decodePartition(long partitionedJoinPosition) {
        return (int)(partitionedJoinPosition & (long)this.partitionMask);
    }

    private int decodeJoinPosition(long partitionedJoinPosition) {
        return Ints.checkedCast((long)(partitionedJoinPosition >>> this.shiftSize));
    }

    private long encodePartitionedJoinPosition(int partition, int joinPosition) {
        return joinPosition << this.shiftSize | partition;
    }

    private class PartitionedLookupOuterPositionIterator
    implements LookupSource.OuterPositionIterator {
        @GuardedBy(value="this")
        private int currentSource;
        @GuardedBy(value="this")
        private int currentPosition;

        public PartitionedLookupOuterPositionIterator() {
            Preconditions.checkState((PartitionedLookupSource.this.visitedPositions != null ? 1 : 0) != 0, (Object)"This is not an outer lookup source");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean appendToNext(PageBuilder pageBuilder, int outputChannelOffset) {
            PartitionedLookupSource partitionedLookupSource = PartitionedLookupSource.this;
            synchronized (partitionedLookupSource) {
                while (this.currentSource < PartitionedLookupSource.this.lookupSources.length) {
                    while (this.currentPosition < PartitionedLookupSource.this.visitedPositions[this.currentSource].length) {
                        if (!PartitionedLookupSource.this.visitedPositions[this.currentSource][this.currentPosition]) {
                            PartitionedLookupSource.this.lookupSources[this.currentSource].appendTo(this.currentPosition, pageBuilder, outputChannelOffset);
                            ++this.currentPosition;
                            return true;
                        }
                        ++this.currentPosition;
                    }
                    this.currentPosition = 0;
                    ++this.currentSource;
                }
                return false;
            }
        }
    }
}

