/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public final class OuterLookupSource
implements LookupSource {
    private final LookupSource lookupSource;
    @GuardedBy(value="this")
    private final boolean[] visitedPositions;

    public OuterLookupSource(LookupSource lookupSource) {
        this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
        this.visitedPositions = new boolean[lookupSource.getJoinPositionCount()];
    }

    @Override
    public int getChannelCount() {
        return this.lookupSource.getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        return this.lookupSource.getJoinPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.lookupSource.getInMemorySizeInBytes();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        return this.lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage, rawHash);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        return this.lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage);
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.lookupSource.getNextJoinPosition(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.lookupSource.appendTo(position, pageBuilder, outputChannelOffset);
        OuterLookupSource outerLookupSource = this;
        synchronized (outerLookupSource) {
            this.visitedPositions[Ints.checkedCast((long)position)] = true;
        }
    }

    @Override
    public synchronized LookupSource.OuterPositionIterator getOuterPositionIterator() {
        return new SharedLookupOuterPositionIterator(this.lookupSource, this.visitedPositions);
    }

    @Override
    public void close() {
    }

    private static class SharedLookupOuterPositionIterator
    implements LookupSource.OuterPositionIterator {
        private final LookupSource lookupSource;
        private final boolean[] visitedPositions;
        @GuardedBy(value="this")
        private int currentPosition;

        public SharedLookupOuterPositionIterator(LookupSource lookupSource, boolean[] visitedPositions) {
            this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
            this.visitedPositions = Objects.requireNonNull(visitedPositions, "visitedPositions is null");
            Preconditions.checkArgument((lookupSource.getJoinPositionCount() == visitedPositions.length ? 1 : 0) != 0);
        }

        @Override
        public synchronized boolean appendToNext(PageBuilder pageBuilder, int outputChannelOffset) {
            while (this.currentPosition < this.visitedPositions.length) {
                if (!this.visitedPositions[this.currentPosition]) {
                    this.lookupSource.appendTo(this.currentPosition, pageBuilder, outputChannelOffset);
                    ++this.currentPosition;
                    return true;
                }
                ++this.currentPosition;
            }
            return false;
        }
    }
}

