/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SettableLookupSourceSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SettableLookupSourceSupplier lookupSourceSupplier;
    private final List<Integer> hashChannels;
    private final Optional<Integer> hashChannel;
    private final Optional<JoinFilterFunction> filterFunction;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public HashBuilderOperator(OperatorContext operatorContext, SettableLookupSourceSupplier lookupSourceSupplier, List<Integer> hashChannels, Optional<Integer> hashChannel, Optional<JoinFilterFunction> filterFunction, int expectedPositions) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.lookupSourceSupplier = Objects.requireNonNull(lookupSourceSupplier, "hashSupplier is null");
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction is null");
        this.pagesIndex = new PagesIndex(lookupSourceSupplier.getTypes(), expectedPositions);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.lookupSourceSupplier.getTypes();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        LookupSource lookupSource = this.pagesIndex.createLookupSource(this.hashChannels, this.hashChannel, this.filterFunction);
        this.lookupSourceSupplier.setLookupSource(lookupSource, this.operatorContext);
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        if (!this.operatorContext.trySetMemoryReservation(this.pagesIndex.getEstimatedSize().toBytes())) {
            this.pagesIndex.compact();
        }
        this.operatorContext.setMemoryReservation(this.pagesIndex.getEstimatedSize().toBytes());
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SettableLookupSourceSupplier lookupSourceSupplier;
        private final List<Integer> hashChannels;
        private final Optional<Integer> hashChannel;
        private final Optional<JoinFilterFunction> filterFunction;
        private final int expectedPositions;
        private State state = State.NOT_CREATED;

        public HashBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> types, Map<Symbol, Integer> layout, List<Integer> hashChannels, Optional<Integer> hashChannel, boolean outer, Optional<JoinFilterFunction> filterFunction, int expectedPositions) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.lookupSourceSupplier = new SettableLookupSourceSupplier(Objects.requireNonNull(types, "types is null"), Objects.requireNonNull(layout, "layout is null"), outer);
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction is null");
            this.expectedPositions = expectedPositions;
        }

        public LookupSourceSupplier getLookupSourceSupplier() {
            return this.lookupSourceSupplier;
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceSupplier.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((this.state == State.NOT_CREATED ? 1 : 0) != 0, (Object)"Only one hash build operator can be created");
            this.state = State.CREATED;
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashBuilderOperator.class.getSimpleName());
            return new HashBuilderOperator(operatorContext, this.lookupSourceSupplier, this.hashChannels, this.hashChannel, this.filterFunction, this.expectedPositions);
        }

        @Override
        public void close() {
            this.state = State.CLOSED;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Hash build can not be duplicated");
        }

        private static enum State {
            NOT_CREATED,
            CREATED,
            CLOSED;

        }
    }
}

