/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class DriverStats {
    private final DateTime createTime;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final DataSize memoryReservation;
    private final DataSize systemMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final Duration rawInputReadTime;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final List<OperatorStats> operatorStats;

    public DriverStats() {
        this.createTime = DateTime.now();
        this.startTime = null;
        this.endTime = null;
        this.queuedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.elapsedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.memoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.systemMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.totalScheduledTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalCpuTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalUserTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.rawInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.rawInputPositions = 0L;
        this.rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.processedInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.processedInputPositions = 0L;
        this.outputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.outputPositions = 0L;
        this.operatorStats = ImmutableList.of();
    }

    @JsonCreator
    public DriverStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="rawInputReadTime") Duration rawInputReadTime, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="operatorStats") List<OperatorStats> operatorStats) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.startTime = startTime;
        this.endTime = endTime;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.memoryReservation = Objects.requireNonNull(memoryReservation, "memoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalUserTime = Objects.requireNonNull(totalUserTime, "totalUserTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.rawInputReadTime = Objects.requireNonNull(rawInputReadTime, "rawInputReadTime is null");
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.operatorStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStats, "operatorStats is null"));
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public Duration getRawInputReadTime() {
        return this.rawInputReadTime;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorStats() {
        return this.operatorStats;
    }
}

