/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.ProcedureRegistry;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final ConcurrentMap<String, ConnectorEntry> informationSchemasByCatalog = new ConcurrentHashMap<String, ConnectorEntry>();
    private final ConcurrentMap<String, ConnectorEntry> systemTablesByCatalog = new ConcurrentHashMap<String, ConnectorEntry>();
    private final ConcurrentMap<String, ConnectorEntry> connectorsByCatalog = new ConcurrentHashMap<String, ConnectorEntry>();
    private final ConcurrentMap<ConnectorId, ConnectorEntry> connectorsById = new ConcurrentHashMap<ConnectorId, ConnectorEntry>();
    private final FunctionRegistry functions;
    private final ProcedureRegistry procedures;
    private final TypeManager typeManager;
    private final JsonCodec<ViewDefinition> viewCodec;
    private final BlockEncodingSerde blockEncodingSerde;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final TransactionManager transactionManager;

    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, TransactionManager transactionManager) {
        this(featuresConfig, typeManager, MetadataManager.createTestingViewCodec(), blockEncodingSerde, sessionPropertyManager, schemaPropertyManager, tablePropertyManager, transactionManager);
    }

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, JsonCodec<ViewDefinition> viewCodec, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, TransactionManager transactionManager) {
        this.functions = new FunctionRegistry(typeManager, blockEncodingSerde, featuresConfig);
        this.procedures = new ProcedureRegistry();
        this.typeManager = Objects.requireNonNull(typeManager, "types is null");
        this.viewCodec = Objects.requireNonNull(viewCodec, "viewCodec is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.verifyComparableOrderableContract();
    }

    public static MetadataManager createTestMetadataManager() {
        TypeRegistry typeManager = new TypeRegistry();
        return new MetadataManager(new FeaturesConfig(), typeManager, new BlockEncodingManager((TypeManager)typeManager, new BlockEncodingFactory[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), TransactionManager.createTestTransactionManager());
    }

    public synchronized void registerConnectorCatalog(ConnectorId connectorId, String catalogName) {
        this.checkMetadataArguments(connectorId, catalogName);
        Preconditions.checkArgument((!this.connectorsByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorEntry connectorEntry = new ConnectorEntry(connectorId, catalogName);
        this.connectorsById.put(connectorId, connectorEntry);
        this.connectorsByCatalog.put(catalogName, connectorEntry);
    }

    public synchronized void registerInformationSchemaCatalog(ConnectorId connectorId, String catalogName) {
        this.checkMetadataArguments(connectorId, catalogName);
        Preconditions.checkArgument((!this.informationSchemasByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Information schema for catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorEntry connectorEntry = new ConnectorEntry(connectorId, catalogName);
        this.connectorsById.put(connectorId, connectorEntry);
        this.informationSchemasByCatalog.put(catalogName, connectorEntry);
    }

    public synchronized void registerSystemTablesCatalog(ConnectorId connectorId, String catalogName) {
        this.checkMetadataArguments(connectorId, catalogName);
        Preconditions.checkArgument((!this.systemTablesByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"System tables for catalog '%s' are already registered", (Object[])new Object[]{catalogName});
        ConnectorEntry connectorEntry = new ConnectorEntry(connectorId, catalogName);
        this.connectorsById.put(connectorId, connectorEntry);
        this.systemTablesByCatalog.put(catalogName, connectorEntry);
    }

    private void checkMetadataArguments(ConnectorId connectorId, String catalogName) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    @Override
    public final void verifyComparableOrderableContract() {
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.typeManager.getTypes()) {
            if (type.isComparable()) {
                if (!this.functions.canResolveOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.functions.canResolveOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.functions.canResolveOperator(OperatorType.NOT_EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.NOT_EQUAL);
                }
            }
            if (!type.isOrderable()) continue;
            for (OperatorType operator : ImmutableList.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL)) {
                if (this.functions.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) continue;
                missingOperators.put((Object)type, (Object)operator);
            }
            if (this.functions.canResolveOperator(OperatorType.BETWEEN, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type, (Object)type))) continue;
            missingOperators.put((Object)type, (Object)OperatorType.BETWEEN);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeManager.getType(signature);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<SqlFunction> listFunctions() {
        return this.functions.list();
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        for (ConnectorEntry entry : this.allConnectorsFor(schema.getCatalogName())) {
            ConnectorMetadata metadata = entry.getMetadata(session);
            if (!metadata.schemaExists(session.toConnectorSession(entry.getConnectorId()), schema.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorEntry entry : this.allConnectorsFor(catalogName)) {
            ConnectorMetadata metadata = entry.getMetadata(session);
            schemaNames.addAll((Iterable)metadata.listSchemaNames(session.toConnectorSession(entry.getConnectorId())));
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        ConnectorEntry entry = this.getConnectorFor(session, table);
        if (entry != null && (tableHandle = (metadata = entry.getMetadata(session)).getTableHandle(session.toConnectorSession(entry.getConnectorId()), table.asSchemaTableName())) != null) {
            return Optional.of(new TableHandle(entry.getConnectorId(), tableHandle));
        }
        return Optional.empty();
    }

    @Override
    public List<TableLayoutResult> getLayouts(Session session, TableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        if (constraint.getSummary().isNone()) {
            return ImmutableList.of();
        }
        TupleDomain summary = constraint.getSummary();
        ConnectorId connectorId = table.getConnectorId();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        Predicate predicate = constraint.predicate();
        ConnectorEntry entry = this.getConnectorMetadata(connectorId);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ConnectorTransactionHandle transaction = entry.getTransactionHandle(session);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
        List layouts = metadata.getTableLayouts(connectorSession, connectorTable, new Constraint(summary, predicate::test), desiredColumns);
        return (List)layouts.stream().map(layout -> new TableLayoutResult(TableLayout.fromConnectorLayout(connectorId, transaction, layout.getTableLayout()), (TupleDomain<ColumnHandle>)layout.getUnenforcedConstraint())).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public TableLayout getLayout(Session session, TableLayoutHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        ConnectorEntry entry = this.getConnectorMetadata(connectorId);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ConnectorTransactionHandle transaction = entry.getTransactionHandle(session);
        return TableLayout.fromConnectorLayout(connectorId, transaction, metadata.getTableLayout(session.toConnectorSession(entry.getConnectorId()), handle.getConnectorHandle()));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableLayoutHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        ConnectorEntry entry = this.getConnectorMetadata(connectorId);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ConnectorTableLayout tableLayout = metadata.getTableLayout(session.toConnectorSession(entry.getConnectorId()), handle.getConnectorHandle());
        return metadata.getInfo(tableLayout.getHandle());
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
        return new TableMetadata(tableHandle.getConnectorId(), tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), mapEntry.getValue());
        }
        return map.build();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        return metadata.getColumnMetadata(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedObjectName> tables = new LinkedHashSet<QualifiedObjectName>();
        for (ConnectorEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorMetadata metadata = entry.getMetadata(session);
            ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
            for (QualifiedObjectName tableName : Iterables.transform((Iterable)metadata.listTables(connectorSession, schemaNameOrNull), QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getSampleWeightColumnHandle(Session session, TableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ColumnHandle handle = metadata.getSampleWeightColumnHandle(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
        return Optional.ofNullable(handle);
    }

    @Override
    public boolean canCreateSampledTables(Session session, String catalogName) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorMetadata metadata = entry.getMetadata(session);
        return metadata.canCreateSampledTables(session.toConnectorSession(entry.getConnectorId()));
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        HashMap tableColumns = new HashMap();
        for (ConnectorEntry connectorEntry : this.allConnectorsFor(prefix.getCatalogName())) {
            QualifiedObjectName tableName;
            ConnectorMetadata metadata = connectorEntry.getMetadata(session);
            ConnectorSession connectorSession = session.toConnectorSession(connectorEntry.getConnectorId());
            for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                tableColumns.put(tableName, entry.getValue());
            }
            for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                ImmutableList.Builder columns = ImmutableList.builder();
                for (ViewDefinition.ViewColumn column : this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()).getColumns()) {
                    columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
                }
                tableColumns.put(tableName, columns.build());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(schema.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{schema.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.createSchema(session.toConnectorSession(entry.getConnectorId()), schema.getSchemaName(), properties);
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(schema.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{schema.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.dropSchema(session.toConnectorSession(entry.getConnectorId()), schema.getSchemaName());
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(source.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{source.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.renameSchema(session.toConnectorSession(entry.getConnectorId()), source.getSchemaName(), target);
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.createTable(session.toConnectorSession(entry.getConnectorId()), tableMetadata);
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        ConnectorEntry target = (ConnectorEntry)this.connectorsByCatalog.get(catalogName);
        if (target == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Target catalog '%s' does not exist", catalogName));
        }
        if (!tableHandle.getConnectorId().equals(target.getConnectorId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.renameTable(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.renameColumn(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.addColumn(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.dropTable(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<NewTableLayout> getInsertLayout(Session session, TableHandle table) {
        ConnectorEntry entry = this.getConnectorMetadata(table.getConnectorId());
        Optional insertLayout = entry.getMetadataForWrite(session).getInsertLayout(session.toConnectorSession(entry.getConnectorId()), table.getConnectorHandle());
        if (!insertLayout.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new NewTableLayout(entry.getConnectorId(), entry.getTransactionHandle(session), (ConnectorNewTableLayout)insertLayout.get()));
    }

    @Override
    public Optional<NewTableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        ConnectorTransactionHandle transactionHandle = entry.getTransactionHandle(session);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new NewTableLayout(entry.getConnectorId(), transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        ConnectorTransactionHandle transactionHandle = entry.getTransactionHandle(session);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(NewTableLayout::getLayout));
        return new OutputTableHandle(entry.getConnectorId(), transactionHandle, handle);
    }

    @Override
    public void finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        metadata.finishCreateTable(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        ConnectorTransactionHandle transactionHandle = entry.getTransactionHandle(session);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), transactionHandle, handle);
    }

    @Override
    public void finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        metadata.finishInsert(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        return metadata.supportsMetadataDelete(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public OptionalLong metadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        return metadata.metadataDelete(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        ConnectorTableHandle newHandle = metadata.beginDelete(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), newHandle);
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        metadata.finishDelete(session.toConnectorSession(entry.getConnectorId()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Map<String, ConnectorId> getCatalogNames() {
        ImmutableMap.Builder catalogsMap = ImmutableMap.builder();
        for (Map.Entry entry : this.connectorsByCatalog.entrySet()) {
            catalogsMap.put(entry.getKey(), (Object)((ConnectorEntry)entry.getValue()).getConnectorId());
        }
        return catalogsMap.build();
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedObjectName> views = new LinkedHashSet<QualifiedObjectName>();
        for (ConnectorEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorMetadata metadata = entry.getMetadata(session);
            ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
            for (QualifiedObjectName tableName : Iterables.transform((Iterable)metadata.listViews(connectorSession, schemaNameOrNull), QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                views.add(tableName);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        LinkedHashMap<QualifiedObjectName, ViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ViewDefinition>();
        for (ConnectorEntry connectorEntry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorMetadata metadata = connectorEntry.getMetadata(session);
            ConnectorSession connectorSession = session.toConnectorSession(connectorEntry.getConnectorId());
            for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                views.put(viewName, this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()));
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        ConnectorMetadata metadata;
        Map views;
        ConnectorViewDefinition view;
        ConnectorEntry entry = this.getConnectorFor(session, viewName);
        if (entry != null && (view = (ConnectorViewDefinition)(views = (metadata = entry.getMetadata(session)).getViews(session.toConnectorSession(entry.getConnectorId()), viewName.asSchemaTableName().toSchemaTablePrefix())).get(viewName.asSchemaTableName())) != null) {
            return Optional.of(this.deserializeView(view.getViewData()));
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, String viewData, boolean replace) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.createView(session.toConnectorSession(entry.getConnectorId()), viewName.asSchemaTableName(), viewData, replace);
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadataForWrite(session);
        metadata.dropView(session.toConnectorSession(entry.getConnectorId()), viewName.asSchemaTableName());
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ConnectorEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorMetadata metadata = entry.getMetadata(session);
        ConnectorTransactionHandle transaction = entry.getTransactionHandle(session);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getConnectorId());
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getConnectorId(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(tableName.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{tableName.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadata(session);
        metadata.grantTablePrivileges(session.toConnectorSession(entry.getConnectorId()), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        ConnectorEntry entry = (ConnectorEntry)this.connectorsByCatalog.get(tableName.getCatalogName());
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{tableName.getCatalogName()});
        ConnectorMetadata metadata = entry.getMetadata(session);
        metadata.revokeTablePrivileges(session.toConnectorSession(entry.getConnectorId()), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functions;
    }

    @Override
    public ProcedureRegistry getProcedureRegistry() {
        return this.procedures;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public SchemaPropertyManager getSchemaPropertyManager() {
        return this.schemaPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private List<ConnectorEntry> allConnectorsFor(String catalogName) {
        ConnectorEntry connector;
        ConnectorEntry systemTables;
        ImmutableList.Builder builder = ImmutableList.builder();
        ConnectorEntry entry = (ConnectorEntry)this.informationSchemasByCatalog.get(catalogName);
        if (entry != null) {
            builder.add((Object)entry);
        }
        if ((systemTables = (ConnectorEntry)this.systemTablesByCatalog.get(catalogName)) != null) {
            builder.add((Object)systemTables);
        }
        if ((connector = (ConnectorEntry)this.connectorsByCatalog.get(catalogName)) != null) {
            builder.add((Object)connector);
        }
        return builder.build();
    }

    private ConnectorEntry getConnectorFor(Session session, QualifiedObjectName name) {
        String catalog = name.getCatalogName();
        String schema = name.getSchemaName();
        if (schema.equals(INFORMATION_SCHEMA_NAME)) {
            return (ConnectorEntry)this.informationSchemasByCatalog.get(catalog);
        }
        ConnectorEntry entry = (ConnectorEntry)this.systemTablesByCatalog.get(catalog);
        if (entry != null && entry.getMetadata(session).getTableHandle(null, name.asSchemaTableName()) != null) {
            return entry;
        }
        return (ConnectorEntry)this.connectorsByCatalog.get(catalog);
    }

    private ConnectorEntry lookupConnectorFor(TableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorEntry lookupConnectorFor(OutputTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorEntry lookupConnectorFor(InsertTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorEntry getConnectorMetadata(ConnectorId connectorId) {
        ConnectorEntry result = (ConnectorEntry)this.connectorsById.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No connector for connector ID: %s", (Object[])new Object[]{connectorId});
        return result;
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(new TypeRegistry()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    private class ConnectorEntry {
        private final ConnectorId connectorId;
        private final String catalog;

        private ConnectorEntry(ConnectorId connectorId, String catalog) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        }

        private ConnectorId getConnectorId() {
            return this.connectorId;
        }

        private String getCatalog() {
            return this.catalog;
        }

        public ConnectorMetadata getMetadata(Session session) {
            return MetadataManager.this.transactionManager.getMetadata(session.getRequiredTransactionId(), this.connectorId);
        }

        public ConnectorMetadata getMetadataForWrite(Session session) {
            TransactionId transactionId = session.getRequiredTransactionId();
            ConnectorMetadata metadata = MetadataManager.this.transactionManager.getMetadata(transactionId, this.connectorId);
            MetadataManager.this.transactionManager.checkConnectorWrite(transactionId, this.connectorId);
            return metadata;
        }

        public ConnectorTransactionHandle getTransactionHandle(Session session) {
            return MetadataManager.this.transactionManager.getConnectorTransaction(session.getRequiredTransactionId(), this.connectorId);
        }
    }
}

