/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractPropertyManager {
    private final ConcurrentMap<String, Map<String, PropertyMetadata<?>>> catalogProperties = new ConcurrentHashMap();
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;

    protected AbstractPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        Objects.requireNonNull(propertyType, "propertyType is null");
        this.propertyType = propertyType;
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
    }

    public final void addProperties(String catalog, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(catalog, "catalog is null");
        Preconditions.checkArgument((!catalog.isEmpty() && catalog.trim().equals(catalog) ? 1 : 0) != 0, (String)"Invalid catalog name '%s'", (Object[])new Object[]{catalog});
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.catalogProperties.putIfAbsent(catalog, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for catalog '%s' are already registered", (Object[])new Object[]{catalog});
    }

    public final Map<String, Object> getProperties(String catalog, Map<String, Expression> sqlPropertyValues, Session session, Metadata metadata, List<Expression> parameters) {
        Map supportedProperties = (Map)this.catalogProperties.get(catalog);
        if (supportedProperties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + catalog);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (Map.Entry<String, Expression> sqlProperty : sqlPropertyValues.entrySet()) {
            Object value;
            Object sqlObjectValue;
            String propertyName = sqlProperty.getKey().toLowerCase(Locale.ENGLISH);
            PropertyMetadata property = (PropertyMetadata)supportedProperties.get(propertyName);
            if (property == null) {
                throw new PrestoException(this.propertyError, String.format("Catalog '%s' does not support %s property '%s'", catalog, this.propertyType, propertyName));
            }
            try {
                sqlObjectValue = this.evaluatePropertyValue(sqlProperty.getValue(), property.getSqlType(), session, metadata, parameters);
            }
            catch (SemanticException e) {
                throw new PrestoException(this.propertyError, String.format("Invalid value for %s property '%s': Cannot convert '%s' to %s", this.propertyType, property.getName(), sqlProperty.getValue(), property.getSqlType()), (Throwable)e);
            }
            try {
                value = property.decode(sqlObjectValue);
            }
            catch (Exception e) {
                throw new PrestoException(this.propertyError, String.format("Unable to set %s property '%s' to '%s': %s", this.propertyType, property.getName(), sqlProperty.getValue(), e.getMessage()), (Throwable)e);
            }
            properties.put((Object)property.getName(), value);
        }
        ImmutableMap userSpecifiedProperties = properties.build();
        for (PropertyMetadata propertyMetadata : supportedProperties.values()) {
            Object value;
            if (userSpecifiedProperties.containsKey(propertyMetadata.getName()) || (value = propertyMetadata.getDefaultValue()) == null) continue;
            properties.put((Object)propertyMetadata.getName(), value);
        }
        return properties.build();
    }

    public Map<String, Map<String, PropertyMetadata<?>>> getAllProperties() {
        return ImmutableMap.copyOf(this.catalogProperties);
    }

    private Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata, List<Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, metadata, session, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(new BlockBuilderStatus(), 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new PrestoException(this.propertyError, String.format("Invalid null value for %s property", this.propertyType));
        }
        return objectValue;
    }
}

