/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"node-scheduler.location-aware-scheduling-enabled"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private boolean multipleTasksPerNode;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerNodePerStage = 10;
    private String networkTopology = "legacy";

    @NotNull
    public String getNetworkTopology() {
        return this.networkTopology;
    }

    @Config(value="node-scheduler.network-topology")
    public NodeSchedulerConfig setNetworkTopology(String networkTopology) {
        this.networkTopology = networkTopology;
        return this;
    }

    public boolean isMultipleTasksPerNodeEnabled() {
        return this.multipleTasksPerNode;
    }

    @ConfigDescription(value="Allow nodes to be selected multiple times by the node scheduler, in a single stage")
    @Config(value="node-scheduler.multiple-tasks-per-node-enabled")
    public NodeSchedulerConfig setMultipleTasksPerNodeEnabled(boolean multipleTasksPerNode) {
        this.multipleTasksPerNode = multipleTasksPerNode;
        return this;
    }

    @Min(value=1L)
    public int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-node-per-stage")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-node-per-task"})
    public NodeSchedulerConfig setMaxPendingSplitsPerNodePerStage(int maxPendingSplitsPerNodePerStage) {
        this.maxPendingSplitsPerNodePerStage = maxPendingSplitsPerNodePerStage;
        return this;
    }

    public int getMaxPendingSplitsPerNodePerStage() {
        return this.maxPendingSplitsPerNodePerStage;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    public static class NetworkTopologyType {
        public static final String LEGACY = "legacy";
        public static final String FLAT = "flat";
        public static final String BENCHMARK = "benchmark";
    }
}

