/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.MemoryTrackingRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.SqlQueryScheduler;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DistributedExecutionPlanner;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.OutputExtractor;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class SqlQueryExecution
implements QueryExecution {
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private final QueryStateMachine stateMachine;
    private final Statement statement;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final RemoteTaskFactory remoteTaskFactory;
    private final LocationFactory locationFactory;
    private final int scheduleSplitBatchSize;
    private final boolean experimentalSyntaxEnabled;
    private final ExecutorService queryExecutor;
    private final QueryExplainer queryExplainer;
    private final AtomicReference<SqlQueryScheduler> queryScheduler = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final ExecutionPolicy executionPolicy;
    private final List<Expression> parameters;

    public SqlQueryExecution(QueryId queryId, String query, Session session, URI self, Statement statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, RemoteTaskFactory remoteTaskFactory, LocationFactory locationFactory, int scheduleSplitBatchSize, boolean experimentalSyntaxEnabled, ExecutorService queryExecutor, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, ExecutionPolicy executionPolicy, List<Expression> parameters) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{queryId});){
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.parameters = Objects.requireNonNull(parameters);
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(query, "query is null");
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(self, "self is null");
            this.stateMachine = QueryStateMachine.begin(queryId, query, session, self, false, transactionManager, queryExecutor);
            this.stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), this.stateMachine);
        }
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public long getTotalMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation().toBytes();
        }
        if (scheduler == null) {
            return 0L;
        }
        return scheduler.getTotalMemoryReservation();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void start() {
        Throwable throwable;
        SetThreadName ignored;
        block24: {
            block25: {
                block26: {
                    block21: {
                        block22: {
                            block23: {
                                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                                throwable = null;
                                if (this.stateMachine.transitionToPlanning()) break block21;
                                if (ignored == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ignored.close();
                        }
                        return;
                    }
                    PlanRoot plan = this.analyzeQuery();
                    this.planDistribution(plan);
                    if (this.stateMachine.transitionToStarting()) break block24;
                    if (ignored == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot analyzeQuery() {
        try {
            return this.doAnalyzeQuery();
        }
        catch (StackOverflowError e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot doAnalyzeQuery() {
        long analysisStart = System.nanoTime();
        Analyzer analyzer = new Analyzer(this.stateMachine.getSession(), this.metadata, this.sqlParser, this.accessControl, Optional.of(this.queryExplainer), this.experimentalSyntaxEnabled, this.parameters);
        Analysis analysis = analyzer.analyze(this.statement);
        this.stateMachine.setUpdateType(analysis.getUpdateType());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.metadata, this.sqlParser);
        Plan plan = logicalPlanner.plan(analysis);
        List<Input> inputs = new InputExtractor(this.metadata, this.stateMachine.getSession()).extractInputs(plan.getRoot());
        this.stateMachine.setInputs(inputs);
        Optional<Output> output = new OutputExtractor().extractOutput(plan.getRoot());
        this.stateMachine.setOutput(output);
        SubPlan subplan = new PlanFragmenter().createSubPlans(this.stateMachine.getSession(), this.metadata, plan);
        this.stateMachine.recordAnalysisTime(analysisStart);
        boolean explainAnalyze = analysis.getStatement() instanceof Explain && ((Explain)analysis.getStatement()).isAnalyze();
        return new PlanRoot(subplan, !explainAnalyze);
    }

    private void planDistribution(PlanRoot plan) {
        long distributedPlanningStart = System.nanoTime();
        DistributedExecutionPlanner distributedPlanner = new DistributedExecutionPlanner(this.splitManager);
        StageExecutionPlan outputStageExecutionPlan = distributedPlanner.plan(plan.getRoot(), this.stateMachine.getSession());
        this.stateMachine.recordDistributedPlanningTime(distributedPlanningStart);
        if (this.stateMachine.isDone()) {
            return;
        }
        this.stateMachine.setOutputFieldNames(outputStageExecutionPlan.getFieldNames());
        PartitioningHandle partitioningHandle = plan.getRoot().getFragment().getPartitioningScheme().getPartitioning().getHandle();
        OutputBuffers rootOutputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(partitioningHandle).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds();
        SqlQueryScheduler scheduler = new SqlQueryScheduler(this.stateMachine, this.locationFactory, outputStageExecutionPlan, this.nodePartitioningManager, this.nodeScheduler, this.remoteTaskFactory, this.stateMachine.getSession(), plan.isSummarizeTaskInfos(), this.scheduleSplitBatchSize, this.queryExecutor, rootOutputBuffers, this.nodeTaskMap, this.executionPolicy);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            Duration duration = this.stateMachine.waitForStateChange(currentState, maxWait);
            return duration;
        }
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
            if (finalQueryInfo.isPresent()) {
                QueryInfo queryInfo = finalQueryInfo.get();
                return queryInfo;
            }
            QueryInfo queryInfo = this.buildQueryInfo(scheduler);
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    private QueryInfo buildQueryInfo(SqlQueryScheduler scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.ofNullable(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<SqlQueryExecution> {
        private final int scheduleSplitBatchSize;
        private final boolean experimentalSyntaxEnabled;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final NodePartitioningManager nodePartitioningManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final RemoteTaskFactory remoteTaskFactory;
        private final TransactionManager transactionManager;
        private final QueryExplainer queryExplainer;
        private final LocationFactory locationFactory;
        private final ExecutorService executor;
        private final NodeTaskMap nodeTaskMap;
        private final Map<String, ExecutionPolicy> executionPolicies;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, FeaturesConfig featuresConfig, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, LocationFactory locationFactory, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, PlanOptimizers planOptimizers, RemoteTaskFactory remoteTaskFactory, TransactionManager transactionManager, @ForQueryExecution ExecutorService executor, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, Map<String, ExecutionPolicy> executionPolicies) {
            Objects.requireNonNull(config, "config is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            Objects.requireNonNull(featuresConfig, "featuresConfig is null");
            this.experimentalSyntaxEnabled = featuresConfig.isExperimentalSyntaxEnabled();
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "schedulerPolicies is null");
            this.planOptimizers = planOptimizers.get();
        }

        @Override
        public SqlQueryExecution createQueryExecution(QueryId queryId, String query, Session session, Statement statement, List<Expression> parameters) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(session);
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object[])new Object[]{executionPolicy});
            return new SqlQueryExecution(queryId, query, session, this.locationFactory.createQueryLocation(queryId), statement, this.transactionManager, this.metadata, this.accessControl, this.sqlParser, this.splitManager, this.nodePartitioningManager, this.nodeScheduler, this.planOptimizers, this.remoteTaskFactory, this.locationFactory, this.scheduleSplitBatchSize, this.experimentalSyntaxEnabled, this.executor, this.nodeTaskMap, this.queryExplainer, executionPolicy, parameters);
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }
    }
}

