/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.transaction.TransactionManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public CompletableFuture<?> execute(ResetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        if (statement.getName().getParts().size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        metadata.getSessionPropertyManager().getSessionPropertyMetadata(statement.getName().toString());
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return CompletableFuture.completedFuture(null);
    }
}

