/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public String explain(CreateTable statement, List<Expression> parameters) {
        return "CREATE TABLE " + statement.getName();
    }

    @Override
    public CompletableFuture<?> execute(CreateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (tableHandle.isPresent()) {
            if (!statement.isNotExists()) {
                throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
            }
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        for (TableElement element : statement.getElements()) {
            Type type = metadata.getType(TypeSignature.parseTypeSignature((String)element.getType()));
            if (type == null || type.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type for column '%s' ", element.getName());
            }
            columns.add(new ColumnMetadata(element.getName(), type));
        }
        accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(tableName.getCatalogName(), statement.getProperties(), session, metadata, parameters);
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), columns, properties, false);
        metadata.createTable(session, tableName.getCatalogName(), tableMetadata);
        return CompletableFuture.completedFuture(null);
    }
}

