/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.event.query.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryContext;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.QueryIOMetadata;
import com.facebook.presto.spi.eventlistener.QueryInputMetadata;
import com.facebook.presto.spi.eventlistener.QueryMetadata;
import com.facebook.presto.spi.eventlistener.QueryOutputMetadata;
import com.facebook.presto.spi.eventlistener.QueryStatistics;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.spi.eventlistener.SplitFailureInfo;
import com.facebook.presto.spi.eventlistener.SplitStatistics;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.io.IOException;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final EventListenerManager eventListenerManager;
    private final ObjectMapper objectMapper;
    private final String serverVersion;
    private final String serverAddress;
    private final String environment;
    private final QueryMonitorConfig config;

    @Inject
    public QueryMonitor(ObjectMapper objectMapper, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, QueryMonitorConfig config) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        this.serverAddress = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getExternalAddress();
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public void queryCreatedEvent(QueryInfo queryInfo) {
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), new QueryContext(queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getSession().getSource(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), QueryMonitor.mergeSessionAndCatalogProperties(queryInfo), this.serverAddress, this.serverVersion, this.environment), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), Optional.empty())));
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        try {
            Optional<Object> queryFailureInfo = Optional.empty();
            if (queryInfo.getFailureInfo() != null) {
                FailureInfo failureInfo = queryInfo.getFailureInfo();
                Optional failedTask = queryInfo.getOutputStage().flatMap(QueryMonitor::findFailedTask);
                queryFailureInfo = Optional.of(new QueryFailureInfo(queryInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskStatus().getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.objectMapper.writeValueAsString((Object)queryInfo.getFailureInfo())));
            }
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (Input input : queryInfo.getInputs()) {
                inputs.add((Object)new QueryInputMetadata(input.getConnectorId().getCatalogName(), input.getSchema(), input.getTable(), input.getColumns().stream().map(Column::toString).collect(Collectors.toList()), input.getConnectorInfo()));
            }
            Optional<Object> output = Optional.empty();
            if (queryInfo.getOutput().isPresent()) {
                output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getConnectorId().getCatalogName(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable()));
            }
            QueryStats queryStats = queryInfo.getQueryStats();
            this.eventListenerManager.queryCompleted(new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), Optional.ofNullable(QueryMonitor.toJsonWithLengthLimit(this.objectMapper, queryInfo.getOutputStage(), Ints.checkedCast((long)this.config.getMaxOutputStageJsonSize().toBytes())))), new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getTotalScheduledTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Optional.ofNullable(queryStats.getAnalysisTime()).map(duration -> Duration.ofMillis(duration.toMillis())), Optional.ofNullable(queryStats.getDistributedPlanningTime()).map(duration -> Duration.ofMillis(duration.toMillis())), queryStats.getPeakMemoryReservation().toBytes(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getCompletedDrivers(), queryInfo.isCompleteInfo()), new QueryContext(queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getSession().getSource(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), QueryMonitor.mergeSessionAndCatalogProperties(queryInfo), this.serverAddress, this.serverVersion, this.environment), new QueryIOMetadata((List)inputs.build(), output), queryFailureInfo, Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime().getMillis())));
            this.logQueryTimeline(queryInfo);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(QueryInfo queryInfo) {
        ImmutableMap.Builder mergedProperties = ImmutableMap.builder();
        mergedProperties.putAll(queryInfo.getSession().getSystemProperties());
        for (Map.Entry<String, Map<String, String>> catalogEntry : queryInfo.getSession().getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry : catalogEntry.getValue().entrySet()) {
                mergedProperties.put((Object)(catalogEntry.getKey() + "." + entry.getKey()), (Object)entry.getValue());
            }
        }
        return mergedProperties.build();
    }

    private void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            long planning = queryStats.getTotalPlanningTime() == null ? 0L : queryStats.getTotalPlanningTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning;
            long lastTaskEndTime = queryStartTime.getMillis() + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            long elapsed = queryEndTime.getMillis() - queryStartTime.getMillis();
            long scheduling = firstTaskStartTime - queryStartTime.getMillis() - planning;
            long running = lastTaskEndTime - firstTaskStartTime;
            long finishing = queryEndTime.getMillis() - lastTaskEndTime;
            log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %sms :: planning %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %s :: end %s", new Object[]{queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), Math.max(elapsed, 0L), Math.max(planning, 0L), Math.max(scheduling, 0L), Math.max(running, 0L), Math.max(finishing, 0L), queryStartTime, queryEndTime});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    public void splitCompletedEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletedEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletedEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletedEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Optional<Object> timeToStart = Optional.empty();
        if (driverStats.getStartTime() != null) {
            timeToStart = Optional.of(Duration.ofMillis(driverStats.getStartTime().getMillis() - driverStats.getCreateTime().getMillis()));
        }
        Optional<Object> timeToEnd = Optional.empty();
        if (driverStats.getEndTime() != null) {
            timeToEnd = Optional.of(Duration.ofMillis(driverStats.getEndTime().getMillis() - driverStats.getCreateTime().getMillis()));
        }
        Optional<Object> splitFailureMetadata = Optional.empty();
        if (failureType != null) {
            splitFailureMetadata = Optional.of(new SplitFailureInfo(failureType, failureMessage != null ? failureMessage : ""));
        }
        try {
            this.eventListenerManager.splitCompleted(new SplitCompletedEvent(taskId.getQueryId().toString(), taskId.getStageId().toString(), Integer.toString(taskId.getId()), driverStats.getCreateTime().toDate().toInstant(), Optional.ofNullable(driverStats.getStartTime()).map(startTime -> startTime.toDate().toInstant()), Optional.ofNullable(driverStats.getEndTime()).map(endTime -> endTime.toDate().toInstant()), new SplitStatistics(Duration.ofMillis(driverStats.getTotalCpuTime().toMillis()), Duration.ofMillis(driverStats.getElapsedTime().toMillis()), Duration.ofMillis(driverStats.getQueuedTime().toMillis()), Duration.ofMillis(driverStats.getTotalUserTime().toMillis()), Duration.ofMillis(driverStats.getRawInputReadTime().toMillis()), driverStats.getRawInputPositions(), driverStats.getRawInputDataSize().toBytes(), timeToStart, timeToEnd), splitFailureMetadata, this.objectMapper.writeValueAsString((Object)driverStats)));
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error processing split completion event for task %s", new Object[]{taskId});
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    static String toJsonWithLengthLimit(ObjectMapper objectMapper, Object value, int lengthLimit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class LengthLimitedWriter
    extends Writer {
        private final Writer writer;
        private final int maxLength;
        private int count;

        public LengthLimitedWriter(Writer writer, int maxLength) {
            this.writer = Objects.requireNonNull(writer, "writer is null");
            this.maxLength = maxLength;
        }

        @Override
        public void write(char[] buffer, int offset, int length) throws IOException {
            this.count += length;
            if (this.count > this.maxLength) {
                throw new LengthLimitExceededException();
            }
            this.writer.write(buffer, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public static class LengthLimitExceededException
        extends IOException {
        }
    }
}

