/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.util.Types;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ColumnJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "columns");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)BigintType.BIGINT).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_size", (Type)BigintType.BIGINT).column("buffer_length", (Type)BigintType.BIGINT).column("decimal_digits", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).column("nullable", (Type)BigintType.BIGINT).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("column_def", (Type)VarcharType.createUnboundedVarcharType()).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("char_octet_length", (Type)BigintType.BIGINT).column("ordinal_position", (Type)BigintType.BIGINT).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("scope_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("scope_schema", (Type)VarcharType.createUnboundedVarcharType()).column("scope_table", (Type)VarcharType.createUnboundedVarcharType()).column("source_data_type", (Type)BigintType.BIGINT).column("is_autoincrement", (Type)VarcharType.createUnboundedVarcharType()).column("is_generatedcolumn", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;

    @Inject
    public ColumnJdbcTable(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        GlobalSystemTransactionHandle transaction = Types.checkType(transactionHandle, GlobalSystemTransactionHandle.class, "transaction");
        Session session = FilterUtil.toSession(transaction.getTransactionId(), connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(this.metadata.getCatalogNames().keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            for (Map.Entry<QualifiedObjectName, List<ColumnMetadata>> entry : this.metadata.listTableColumns(session, prefix).entrySet()) {
                ColumnJdbcTable.addColumnRows(table, entry.getKey(), entry.getValue());
            }
        }
        return table.build().cursor();
    }

    private static void addColumnRows(InMemoryRecordSet.Builder builder, QualifiedObjectName tableName, List<ColumnMetadata> columns) {
        int ordinalPosition = 1;
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            builder.addRow(new Object[]{tableName.getCatalogName(), tableName.getSchemaName(), tableName.getObjectName(), column.getName(), ColumnJdbcTable.jdbcDataType(column.getType()), column.getType().getDisplayName(), ColumnJdbcTable.columnSize(column.getType()), 0, ColumnJdbcTable.decimalDigits(column.getType()), ColumnJdbcTable.numPrecRadix(column.getType()), 2, column.getComment(), null, null, null, ColumnJdbcTable.charOctetLength(column.getType()), ordinalPosition, "", null, null, null, null, null, null});
            ++ordinalPosition;
        }
    }

    private static int jdbcDataType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return 16;
        }
        if (type.equals(BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 4;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return -6;
        }
        if (type.equals(RealType.REAL)) {
            return 7;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 8;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (Varchars.isVarcharType((Type)type)) {
            return -16;
        }
        if (Chars.isCharType((Type)type)) {
            return 1;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return -4;
        }
        if (type.equals(TimeType.TIME)) {
            return 92;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 2013;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return 93;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return 2014;
        }
        if (type.equals(DateType.DATE)) {
            return 91;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        return 2000;
    }

    private static Integer columnSize(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return 19;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 10;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return 3;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getPrecision();
        }
        if (type.equals(RealType.REAL)) {
            return 24;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 53;
        }
        if (Varchars.isVarcharType((Type)type)) {
            return ((VarcharType)type).getLength();
        }
        if (Chars.isCharType((Type)type)) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        if (type.equals(TimeType.TIME)) {
            return 8;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 14;
        }
        if (type.equals(DateType.DATE)) {
            return 14;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return 23;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return 29;
        }
        return null;
    }

    private static Integer decimalDigits(Type type) {
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getScale();
        }
        return null;
    }

    private static Integer charOctetLength(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            return ((VarcharType)type).getLength();
        }
        if (Chars.isCharType((Type)type)) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }

    private static Integer numPrecRadix(Type type) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type instanceof DecimalType) {
            return 10;
        }
        if (type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE)) {
            return 2;
        }
        return null;
    }
}

