/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;

abstract class AbstractPropertiesSystemTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Supplier<Map<String, Map<String, PropertyMetadata<?>>>> propertySupplier;

    protected AbstractPropertiesSystemTable(String tableName, Supplier<Map<String, Map<String, PropertyMetadata<?>>>> propertySupplier) {
        this.tableMetadata = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", tableName)).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("property_name", (Type)VarcharType.createUnboundedVarcharType()).column("default_value", (Type)VarcharType.createUnboundedVarcharType()).column("type", (Type)VarcharType.createUnboundedVarcharType()).column("description", (Type)VarcharType.createUnboundedVarcharType()).build();
        this.propertySupplier = Objects.requireNonNull(propertySupplier, "propertySupplier is null");
    }

    public final SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public final ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public final RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.tableMetadata);
        TreeMap tableProperties = new TreeMap(this.propertySupplier.get());
        for (Map.Entry entry : tableProperties.entrySet()) {
            String catalog = (String)entry.getKey();
            TreeMap properties = new TreeMap((Map)entry.getValue());
            for (PropertyMetadata propertyMetadata : properties.values()) {
                table.addRow(new Object[]{catalog, propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()});
            }
        }
        return table.build().cursor();
    }
}

