/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.ConnectorAwareNodeManager;
import com.facebook.presto.connector.ConnectorContextInstance;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.RecordPageSinkProvider;
import com.facebook.presto.split.RecordPageSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.transaction.LegacyTransactionConnectorFactory;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class ConnectorManager {
    private static final Logger log = Logger.get(ConnectorManager.class);
    private final MetadataManager metadataManager;
    private final AccessControlManager accessControlManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final InternalNodeManager nodeManager;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final TransactionManager transactionManager;
    @GuardedBy(value="this")
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    @GuardedBy(value="this")
    private final Set<String> catalogs = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final ConcurrentMap<ConnectorId, Connector> connectors = new ConcurrentHashMap<ConnectorId, Connector>();
    private final AtomicBoolean stopped = new AtomicBoolean();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, AccessControlManager accessControlManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, InternalNodeManager nodeManager, NodeInfo nodeInfo, TypeManager typeManager, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, TransactionManager transactionManager) {
        this.metadataManager = metadataManager;
        this.accessControlManager = accessControlManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.nodePartitioningManager = nodePartitioningManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.typeManager = typeManager;
        this.pageSorter = pageSorter;
        this.pageIndexerFactory = pageIndexerFactory;
        this.nodeInfo = nodeInfo;
        this.transactionManager = transactionManager;
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.connectors.entrySet()) {
            Connector connector = (Connector)entry.getValue();
            try {
                ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());
                Throwable throwable = null;
                try {
                    connector.shutdown();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{entry.getKey()});
            }
        }
    }

    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object[])new Object[]{connectorFactory.getName()});
        this.handleResolver.addConnectorName(connectorFactory.getName(), connectorFactory.getHandleResolver());
    }

    public synchronized ConnectorId createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Objects.requireNonNull(connectorName, "connectorName is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object[])new Object[]{connectorName});
        return this.createConnection(catalogName, connectorFactory, properties);
    }

    private synchronized ConnectorId createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Preconditions.checkArgument((!this.catalogs.contains(catalogName) ? 1 : 0) != 0, (String)"A catalog already exists for %s", (Object[])new Object[]{catalogName});
        ConnectorId connectorId = new ConnectorId(catalogName);
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        this.addCatalogConnector(catalogName, connectorId, connectorFactory, properties);
        this.catalogs.add(catalogName);
        return connectorId;
    }

    private synchronized void addCatalogConnector(String catalogName, ConnectorId connectorId, ConnectorFactory factory, Map<String, String> properties) {
        Connector connector = this.createConnector(connectorId, factory, properties);
        this.addConnectorInternal(ConnectorType.STANDARD, catalogName, connectorId, connector);
        ConnectorId informationSchemaId = ConnectorId.createInformationSchemaConnectorId(connectorId);
        this.addConnectorInternal(ConnectorType.INFORMATION_SCHEMA, catalogName, informationSchemaId, new InformationSchemaConnector(catalogName, this.nodeManager, this.metadataManager));
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId(connectorId);
        this.addConnectorInternal(ConnectorType.SYSTEM, catalogName, systemId, new SystemConnector(systemId, this.nodeManager, connector.getSystemTables(), transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, connectorId)));
        this.metadataManager.getSessionPropertyManager().addConnectorSessionProperties(catalogName, connector.getSessionProperties());
        this.metadataManager.getSchemaPropertyManager().addProperties(catalogName, connector.getSchemaProperties());
        this.metadataManager.getTablePropertyManager().addProperties(catalogName, connector.getTableProperties());
    }

    private synchronized void addConnectorInternal(ConnectorType type, String catalogName, ConnectorId connectorId, Connector connector) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        this.connectors.put(connectorId, connector);
        ConnectorSplitManager connectorSplitManager = connector.getSplitManager();
        Preconditions.checkState((connectorSplitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object[])new Object[]{connectorId});
        Set systemTables = connector.getSystemTables();
        Objects.requireNonNull(systemTables, "Connector %s returned a null system tables set");
        Set procedures = connector.getProcedures();
        Objects.requireNonNull(procedures, "Connector %s returned a null procedures set");
        ConnectorPageSourceProvider connectorPageSourceProvider = null;
        try {
            connectorPageSourceProvider = connector.getPageSourceProvider();
            Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector %s returned a null page source provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (connectorPageSourceProvider == null) {
            ConnectorRecordSetProvider connectorRecordSetProvider = null;
            try {
                connectorRecordSetProvider = connector.getRecordSetProvider();
                Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector %s returned a null record set provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s has neither a PageSource or RecordSet provider", (Object[])new Object[]{connectorId});
            connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
        }
        ConnectorPageSinkProvider connectorPageSinkProvider = null;
        try {
            connectorPageSinkProvider = connector.getPageSinkProvider();
            Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector %s returned a null page sink provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (connectorPageSinkProvider == null) {
            try {
                ConnectorRecordSinkProvider connectorRecordSinkProvider = connector.getRecordSinkProvider();
                Objects.requireNonNull(connectorRecordSinkProvider, String.format("Connector %s returned a null record sink provider", connectorId));
                connectorPageSinkProvider = new RecordPageSinkProvider(connectorRecordSinkProvider);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        ConnectorIndexProvider indexProvider = null;
        try {
            indexProvider = connector.getIndexProvider();
            Objects.requireNonNull(indexProvider, String.format("Connector %s returned a null index provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ConnectorNodePartitioningProvider partitioningProvider = null;
        try {
            partitioningProvider = connector.getNodePartitioningProvider();
            Objects.requireNonNull(partitioningProvider, String.format("Connector %s returned a null partitioning provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ConnectorAccessControl accessControl = null;
        try {
            accessControl = connector.getAccessControl();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.transactionManager.addConnector(connectorId, connector);
        if (type == ConnectorType.STANDARD) {
            this.metadataManager.registerConnectorCatalog(connectorId, catalogName);
        } else if (type == ConnectorType.INFORMATION_SCHEMA) {
            this.metadataManager.registerInformationSchemaCatalog(connectorId, catalogName);
        } else if (type == ConnectorType.SYSTEM) {
            this.metadataManager.registerSystemTablesCatalog(connectorId, catalogName);
        } else {
            throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)type));
        }
        this.splitManager.addConnectorSplitManager(connectorId, connectorSplitManager);
        this.pageSourceManager.addConnectorPageSourceProvider(connectorId, connectorPageSourceProvider);
        for (Procedure procedure : procedures) {
            this.metadataManager.getProcedureRegistry().addProcedure(catalogName, procedure);
        }
        if (connectorPageSinkProvider != null) {
            this.pageSinkManager.addConnectorPageSinkProvider(connectorId, connectorPageSinkProvider);
        }
        if (indexProvider != null) {
            this.indexManager.addIndexProvider(connectorId, indexProvider);
        }
        if (partitioningProvider != null) {
            this.nodePartitioningManager.addPartitioningProvider(connectorId, partitioningProvider);
        }
        if (accessControl != null) {
            this.accessControlManager.addCatalogAccessControl(connectorId, catalogName, accessControl);
        }
    }

    private Connector createConnector(ConnectorId connectorId, ConnectorFactory factory, Map<String, String> properties) {
        Class<?> factoryClass = factory.getClass();
        if (factory instanceof LegacyTransactionConnectorFactory) {
            factoryClass = ((LegacyTransactionConnectorFactory)factory).getConnectorFactory().getClass();
        }
        ConnectorContextInstance context = new ConnectorContextInstance(new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), connectorId), this.typeManager, this.pageSorter, this.pageIndexerFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factoryClass.getClassLoader());){
            Connector connector = factory.create(connectorId.getCatalogName(), properties, (ConnectorContext)context);
            return connector;
        }
    }

    private static enum ConnectorType {
        STANDARD,
        INFORMATION_SCHEMA,
        SYSTEM;

    }
}

