/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.units.Duration;
import java.net.URI;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;

public final class Session {
    private final QueryId queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Identity identity;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, String> preparedStatements;

    public Session(QueryId queryId, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Identity identity, Optional<String> source, Optional<String> catalog, Optional<String> schema, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, long startTime, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogProperties, SessionPropertyManager sessionPropertyManager, Map<String, String> preparedStatements) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.identity = identity;
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        catalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.catalogProperties = catalogPropertiesBuilder.build();
        Preconditions.checkArgument((catalog.isPresent() || !schema.isPresent() ? 1 : 0) != 0, (Object)"schema is set but catalog is not");
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getUser() {
        return this.identity.getUser();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public TransactionId getRequiredTransactionId() {
        Preconditions.checkState((boolean)this.transactionId.isPresent(), (Object)"Not in a transaction");
        return this.transactionId.get();
    }

    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    public <T> T getProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeProperty(name, this.systemProperties.get(name), type);
    }

    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Map<String, String> getCatalogProperties(String catalog) {
        return this.catalogProperties.getOrDefault(catalog, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getPreparedStatementFromExecute(Execute execute) {
        String name = execute.getName();
        String sql = this.preparedStatements.get(name);
        Failures.checkCondition(sql != null, (ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + name, new Object[0]);
        return sql;
    }

    public Session withTransactionId(TransactionId transactionId) {
        Objects.requireNonNull(transactionId, "transactionId is null");
        Preconditions.checkArgument((!this.transactionId.isPresent() ? 1 : 0) != 0, (Object)"Session already has an active transaction");
        return this.withTransactionId(Optional.of(transactionId));
    }

    public Session withoutTransactionId() {
        return this.withTransactionId(Optional.empty());
    }

    private Session withTransactionId(Optional<TransactionId> transactionId) {
        return new Session(this.queryId, transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties, this.sessionPropertyManager, this.preparedStatements);
    }

    public Session withSystemProperty(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        LinkedHashMap<String, String> systemProperties = new LinkedHashMap<String, String>(this.systemProperties);
        systemProperties.put(key, value);
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, systemProperties, this.catalogProperties, this.sessionPropertyManager, this.preparedStatements);
    }

    public Session withCatalogProperty(String catalog, String key, String value) {
        Objects.requireNonNull(catalog, "catalog is null");
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        LinkedHashMap<String, Map<String, String>> catalogProperties = new LinkedHashMap<String, Map<String, String>>(this.catalogProperties);
        LinkedHashMap<String, String> properties = (LinkedHashMap<String, String>)catalogProperties.get(catalog);
        properties = properties == null ? new LinkedHashMap<String, String>() : new LinkedHashMap(properties);
        properties.put(key, value);
        catalogProperties.put(catalog, properties);
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, catalogProperties, this.sessionPropertyManager, this.preparedStatements);
    }

    public Session withPreparedStatement(String statementName, String query) {
        Objects.requireNonNull(statementName, "statementName is null");
        Objects.requireNonNull(query, "query is null");
        HashMap<String, String> preparedStatements = new HashMap<String, String>(this.getPreparedStatements());
        preparedStatements.put(statementName, query);
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties, this.sessionPropertyManager, preparedStatements);
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this.queryId.toString(), this.identity, this.timeZoneKey, this.locale, this.startTime);
    }

    public ConnectorSession toConnectorSession(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        return new FullConnectorSession(this.queryId.toString(), this.identity, this.timeZoneKey, this.locale, this.startTime, this.catalogProperties.getOrDefault(connectorId.getCatalogName(), (Map<String, String>)ImmutableMap.of()), connectorId.getCatalogName(), this.sessionPropertyManager);
    }

    public ClientSession toClientSession(URI server, boolean debug, Duration clientRequestTimeout) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(this.systemProperties);
        for (Map.Entry<String, Map<String, String>> catalogProperties : this.catalogProperties.entrySet()) {
            String catalog = catalogProperties.getKey();
            for (Map.Entry<String, String> entry : catalogProperties.getValue().entrySet()) {
                properties.put((Object)(catalog + "." + entry.getKey()), (Object)entry.getValue());
            }
        }
        return new ClientSession(Objects.requireNonNull(server, "server is null"), this.identity.getUser(), (String)this.source.orElse(null), (String)this.catalog.orElse(null), (String)this.schema.orElse(null), this.timeZoneKey.getId(), this.locale, (Map)properties.build(), this.preparedStatements, (String)this.transactionId.map(TransactionId::toString).orElse(null), debug, clientRequestTimeout);
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.queryId.toString(), this.transactionId, this.clientTransactionSupport, this.identity.getUser(), this.identity.getPrincipal().map(Principal::toString), this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties, this.preparedStatements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("transactionId", this.transactionId).add("user", (Object)this.getUser()).add("principal", this.getIdentity().getPrincipal().orElse(null)).add("source", this.source.orElse(null)).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress.orElse(null)).add("userAgent", this.userAgent.orElse(null)).add("startTime", this.startTime).omitNullValues().toString();
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    public static class SessionBuilder {
        private QueryId queryId;
        private TransactionId transactionId;
        private boolean clientTransactionSupport;
        private Identity identity;
        private String source;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private long startTime = System.currentTimeMillis();
        private Map<String, String> systemProperties = ImmutableMap.of();
        private final Map<String, Map<String, String>> catalogProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;
        private Map<String, String> preparedStatements = ImmutableMap.of();

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        }

        public SessionBuilder setQueryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            return this;
        }

        public SessionBuilder setTransactionId(TransactionId transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public SessionBuilder setClientTransactionSupport() {
            this.clientTransactionSupport = true;
            return this;
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = ImmutableMap.copyOf(systemProperties);
            return this;
        }

        public SessionBuilder setCatalogProperties(String catalog, Map<String, String> properties) {
            Objects.requireNonNull(catalog, "catalog is null");
            Preconditions.checkArgument((!catalog.isEmpty() ? 1 : 0) != 0, (Object)"catalog is empty");
            this.catalogProperties.put(catalog, (Map<String, String>)ImmutableMap.copyOf(properties));
            return this;
        }

        public void setPreparedStatements(Map<String, String> preparedStatements) {
            this.preparedStatements = ImmutableMap.copyOf(preparedStatements);
        }

        public Session build() {
            return new Session(this.queryId, Optional.ofNullable(this.transactionId), this.clientTransactionSupport, this.identity, Optional.ofNullable(this.source), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.timeZoneKey, this.locale, Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), this.startTime, this.systemProperties, this.catalogProperties, this.sessionPropertyManager, this.preparedStatements);
        }
    }
}

