/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;

public final class VarbinaryOperators {
    private VarbinaryOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="varbinary") Slice left, @SqlType(value="varbinary") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="varbinary") Slice value, @SqlType(value="varbinary") Slice min, @SqlType(value="varbinary") Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="varbinary") Slice value) {
        return XxHash64.hash((Slice)value);
    }
}

