/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FloatType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.P4HyperLogLogType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.CodePointsType;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.DecimalParametricType;
import com.facebook.presto.type.FunctionParametricType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.JoniRegexpType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.Re2JRegexpType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarcharParametricType;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class TypeRegistry
implements TypeManager {
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();

    public TypeRegistry() {
        this((Set<Type>)ImmutableSet.of());
    }

    @Inject
    public TypeRegistry(Set<Type> types) {
        Objects.requireNonNull(types, "types is null");
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)IntegerType.INTEGER);
        this.addType((Type)SmallintType.SMALLINT);
        this.addType((Type)TinyintType.TINYINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)FloatType.FLOAT);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)P4HyperLogLogType.P4_HYPER_LOG_LOG);
        this.addType((Type)JoniRegexpType.JONI_REGEXP);
        this.addType((Type)Re2JRegexpType.RE2J_REGEXP);
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addType((Type)CodePointsType.CODE_POINTS);
        this.addParametricType(VarcharParametricType.VARCHAR);
        this.addParametricType(DecimalParametricType.DECIMAL);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        for (Type type : types) {
            this.addType(type);
        }
    }

    public Type getType(TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            return this.instantiateParametricType(signature);
        }
        return type;
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters));
    }

    private Type instantiateParametricType(TypeSignature signature) {
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)this);
            if (typeParameter == null) {
                return null;
            }
            parameters.add(typeParameter);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            return null;
        }
        try {
            Type instantiatedType = parametricType.createType(parameters);
            return instantiatedType;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public boolean isTypeOnlyCoercion(Type source, Type result) {
        String resultTypeBase;
        if (source.equals(result)) {
            return true;
        }
        if (!this.canCoerce(source, result)) {
            return false;
        }
        if (source instanceof VarcharType && result instanceof VarcharType) {
            return true;
        }
        if (source instanceof DecimalType && result instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)source;
            DecimalType resultDecimal = (DecimalType)result;
            boolean sameDecimalSubtype = sourceDecimal.isShort() && resultDecimal.isShort() || !sourceDecimal.isShort() && !resultDecimal.isShort();
            boolean sameScale = sourceDecimal.getScale() == resultDecimal.getScale();
            boolean sourcePrecisionIsLessOrEqualToResultPrecision = sourceDecimal.getPrecision() <= resultDecimal.getPrecision();
            return sameDecimalSubtype && sameScale && sourcePrecisionIsLessOrEqualToResultPrecision;
        }
        String sourceTypeBase = source.getTypeSignature().getBase();
        if (sourceTypeBase.equals(resultTypeBase = result.getTypeSignature().getBase()) && TypeRegistry.isCovariantParametrizedType(source)) {
            List sourceTypeParameters = source.getTypeParameters();
            List resultTypeParameters = result.getTypeParameters();
            Preconditions.checkState((sourceTypeParameters.size() == resultTypeParameters.size() ? 1 : 0) != 0);
            for (int i = 0; i < sourceTypeParameters.size(); ++i) {
                if (this.isTypeOnlyCoercion((Type)sourceTypeParameters.get(i), (Type)resultTypeParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        String secondTypeBaseName;
        if (firstType.equals(secondType)) {
            return Optional.of(secondType);
        }
        if (firstType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of(secondType);
        }
        if (secondType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of(firstType);
        }
        String firstTypeBaseName = firstType.getTypeSignature().getBase();
        if (firstTypeBaseName.equals(secondTypeBaseName = secondType.getTypeSignature().getBase())) {
            if (firstTypeBaseName.equals("decimal")) {
                return Optional.of(this.getCommonSuperTypeForDecimal(Types.checkType(firstType, DecimalType.class, "firstType"), Types.checkType(secondType, DecimalType.class, "secondType")));
            }
            if (firstTypeBaseName.equals("varchar")) {
                return Optional.of(this.getCommonSuperTypeForVarchar(Types.checkType(firstType, VarcharType.class, "firstType"), Types.checkType(secondType, VarcharType.class, "secondType")));
            }
            if (TypeRegistry.isCovariantParametrizedType(firstType)) {
                return this.getCommonSupperTypeForCovariantParametrizedType(firstType, secondType);
            }
            return Optional.empty();
        }
        Optional<Type> coercedType = this.coerceTypeBase(firstType, secondType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            return this.getCommonSuperType(coercedType.get(), secondType);
        }
        coercedType = this.coerceTypeBase(secondType, firstType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            return this.getCommonSuperType(firstType, coercedType.get());
        }
        return Optional.empty();
    }

    private Type getCommonSuperTypeForDecimal(DecimalType firstType, DecimalType secondType) {
        int targetScale = Math.max(firstType.getScale(), secondType.getScale());
        int targetPrecision = Math.max(firstType.getPrecision() - firstType.getScale(), secondType.getPrecision() - secondType.getScale()) + targetScale;
        targetPrecision = Math.min(38, targetPrecision);
        return DecimalType.createDecimalType((int)targetPrecision, (int)targetScale);
    }

    private Type getCommonSuperTypeForVarchar(VarcharType firstType, VarcharType secondType) {
        return VarcharType.createVarcharType((int)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private Optional<Type> getCommonSupperTypeForCovariantParametrizedType(Type firstType, Type secondType) {
        Preconditions.checkState((boolean)firstType.getClass().equals(secondType.getClass()));
        ImmutableList.Builder commonParameterTypes = ImmutableList.builder();
        List firstTypeParameters = firstType.getTypeParameters();
        List secondTypeParameters = secondType.getTypeParameters();
        Preconditions.checkState((firstTypeParameters.size() == secondTypeParameters.size() ? 1 : 0) != 0);
        for (int i = 0; i < firstTypeParameters.size(); ++i) {
            Optional<Type> commonParameterType = this.getCommonSuperType((Type)firstTypeParameters.get(i), (Type)secondTypeParameters.get(i));
            if (!commonParameterType.isPresent()) {
                return Optional.empty();
            }
            commonParameterTypes.add((Object)TypeSignatureParameter.of((TypeSignature)commonParameterType.get().getTypeSignature()));
        }
        String typeName = firstType.getTypeSignature().getBase();
        return Optional.of(this.getType(new TypeSignature(typeName, (List)commonParameterTypes.build())));
    }

    public void addType(Type type) {
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object[])new Object[]{type});
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object[])new Object[]{name});
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        String sourceTypeName = sourceType.getTypeSignature().getBase();
        if (sourceTypeName.equals(resultTypeBase)) {
            return Optional.of(sourceType);
        }
        switch (sourceTypeName) {
            case "unknown": {
                switch (resultTypeBase) {
                    case "boolean": 
                    case "bigint": 
                    case "integer": 
                    case "double": 
                    case "varbinary": 
                    case "date": 
                    case "time": 
                    case "time with time zone": 
                    case "timestamp": 
                    case "timestamp with time zone": 
                    case "HyperLogLog": 
                    case "P4HyperLogLog": 
                    case "json": 
                    case "interval year to month": 
                    case "interval day to second": 
                    case "JoniRegExp": 
                    case "LikePattern": 
                    case "JsonPath": 
                    case "color": 
                    case "CodePoints": {
                        return Optional.of(this.getType(new TypeSignature(resultTypeBase, new TypeSignatureParameter[0])));
                    }
                    case "varchar": {
                        return Optional.of(VarcharType.createVarcharType((int)0));
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)1, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "tinyint": {
                switch (resultTypeBase) {
                    case "smallint": {
                        return Optional.of(SmallintType.SMALLINT);
                    }
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)3, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "smallint": {
                switch (resultTypeBase) {
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)5, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "integer": {
                switch (resultTypeBase) {
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)10, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "bigint": {
                switch (resultTypeBase) {
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)19, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "decimal": {
                switch (resultTypeBase) {
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "date": {
                switch (resultTypeBase) {
                    case "timestamp": {
                        return Optional.of(TimestampType.TIMESTAMP);
                    }
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "time": {
                switch (resultTypeBase) {
                    case "time with time zone": {
                        return Optional.of(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "timestamp": {
                switch (resultTypeBase) {
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "varchar": {
                switch (resultTypeBase) {
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(Re2JRegexpType.RE2J_REGEXP);
                    }
                    case "LikePattern": {
                        return Optional.of(LikePatternType.LIKE_PATTERN);
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "P4HyperLogLog": {
                switch (resultTypeBase) {
                    case "HyperLogLog": {
                        return Optional.of(HyperLogLogType.HYPER_LOG_LOG);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean isCovariantParametrizedType(Type type) {
        return type instanceof MapType || type instanceof ArrayType;
    }
}

