/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class TinyintOperators {
    private TinyintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="tinyint")
    public static long add(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left + right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint addition overflow: %s + %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="tinyint")
    public static long subtract(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left - right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint subtraction overflow: %s - %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="tinyint")
    public static long multiply(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return SignedBytes.checkedCast((long)(left * right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("tinyint multiplication overflow: %s * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="tinyint")
    public static long divide(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="tinyint")
    public static long modulus(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="tinyint")
    public static long negate(@SqlType(value="tinyint") long value) {
        try {
            return SignedBytes.checkedCast((long)(-value));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "tinyint negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="tinyint") long left, @SqlType(value="tinyint") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="tinyint") long value, @SqlType(value="tinyint") long min, @SqlType(value="tinyint") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="tinyint") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="tinyint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="float")
    public static long castToFloat(@SqlType(value="tinyint") long value) {
        return Float.floatToRawIntBits(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="tinyint") long value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="tinyint") long value) {
        return (byte)value;
    }
}

