/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

public final class TimestampOperators {
    private TimestampOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="timestamp") long value, @SqlType(value="timestamp") long min, @SqlType(value="timestamp") long max) {
        return min <= value && value <= max;
    }

    @ScalarFunction(value="date")
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="date")
    public static long castToDate(ConnectorSession session, @SqlType(value="timestamp") long value) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        long date = chronology.dayOfYear().roundFloor(value);
        long millis = date + (long)chronology.getZone().getOffset(date);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time")
    public static long castToTime(ConnectorSession session, @SqlType(value="timestamp") long value) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time with time zone")
    public static long castToTimeWithTimeZone(ConnectorSession session, @SqlType(value="timestamp") long value) {
        int timeMillis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), value);
        return DateTimeEncoding.packDateTimeWithZone((long)timeMillis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(ConnectorSession session, @SqlType(value="timestamp") long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(ConnectorSession session, @SqlType(value="timestamp") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printTimestampWithoutTimeZone(session.getTimeZoneKey(), value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castFromSlice(ConnectorSession session, @SqlType(value="varchar") Slice value) {
        try {
            return DateTimeUtils.parseTimestampWithoutTimeZone(session.getTimeZoneKey(), SliceUtf8.trim((Slice)value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="timestamp") long value) {
        return value;
    }
}

