/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class TimeWithTimeZoneOperators {
    private TimeWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) != DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) > DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) >= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="time with time zone") long value, @SqlType(value="time with time zone") long min, @SqlType(value="time with time zone") long max) {
        return DateTimeEncoding.unpackMillisUtc((long)min) <= DateTimeEncoding.unpackMillisUtc((long)value) && DateTimeEncoding.unpackMillisUtc((long)value) <= DateTimeEncoding.unpackMillisUtc((long)max);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time")
    public static long castToTime(ConnectorSession session, @SqlType(value="time with time zone") long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castToTimestamp(@SqlType(value="time with time zone") long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(@SqlType(value="time with time zone") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(@SqlType(value="time with time zone") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printTimeWithTimeZone(value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="time with time zone") long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }
}

