/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class FloatOperators {
    private FloatOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="float")
    public static long add(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) + Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="float")
    public static long subtract(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) - Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="float")
    public static long multiply(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) * Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="float")
    public static long divide(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) / Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="float")
    public static long modulus(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) % Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="float")
    public static long negate(@SqlType(value="float") long value) {
        return Float.floatToRawIntBits(-Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) == Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) != Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) < Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) <= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) > Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="float") long left, @SqlType(value="float") long right) {
        return Float.intBitsToFloat((int)left) >= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="float") long value, @SqlType(value="float") long min, @SqlType(value="float") long max) {
        return Float.intBitsToFloat((int)min) <= Float.intBitsToFloat((int)value) && Float.intBitsToFloat((int)value) <= Float.intBitsToFloat((int)max);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="float") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="float") long value) {
        return Slices.utf8Slice((String)String.valueOf(Float.intBitsToFloat((int)value)));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="float") long value) {
        return (long)MathFunctions.round(Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="float") long value) {
        try {
            return Ints.checkedCast((long)((long)MathFunctions.round(Float.intBitsToFloat((int)value))));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="float") long value) {
        try {
            return Shorts.checkedCast((long)((long)MathFunctions.round(Float.intBitsToFloat((int)value))));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="float") long value) {
        try {
            return SignedBytes.checkedCast((long)((long)MathFunctions.round(Float.intBitsToFloat((int)value))));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="float") long value) {
        return Float.intBitsToFloat((int)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="float") long value) {
        return Float.intBitsToFloat((int)value) != 0.0f;
    }
}

