/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.RoundingMode;

public final class DoubleOperators {
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;

    private DoubleOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="double")
    public static double add(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="double")
    public static double subtract(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="double")
    public static double multiply(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="double")
    public static double divide(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="double")
    public static double modulus(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="double")
    public static double negate(@SqlType(value="double") double value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="double") double value, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="double") double value) {
        return value != 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="double") double value) {
        try {
            return Ints.checkedCast((long)((long)MathFunctions.round(value)));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="double") double value) {
        try {
            return Shorts.checkedCast((long)((long)MathFunctions.round(value)));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="double") double value) {
        try {
            return SignedBytes.checkedCast((long)((long)MathFunctions.round(value)));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="double") double value) {
        return (long)MathFunctions.round(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="float")
    public static long castToFloat(@SqlType(value="double") double value) {
        return Float.floatToRawIntBits((float)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="double") double value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="double") double value) {
        return Double.doubleToLongBits(value);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="bigint")
    public static long saturatedFloorCastToBigint(@SqlType(value="double") double value) {
        if (value <= -9.223372036854776E18) {
            return Long.MIN_VALUE;
        }
        if (9.223372036854776E18 - value <= 1.0) {
            return Long.MAX_VALUE;
        }
        return DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="integer")
    public static long saturatedFloorCastToInteger(@SqlType(value="double") double value) {
        if (value <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (2.147483647E9 - value <= 1.0) {
            return Integer.MAX_VALUE;
        }
        return DoubleMath.roundToInt((double)value, (RoundingMode)RoundingMode.FLOOR);
    }
}

